/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.pipe.bean.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.factory.process.pipe.bean.configuration.AbstractConfigurationParser;
import com.github.codingdebugallday.integration.IntegrationConfiguration;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.Resource;

public class YamlConfigurationParser
extends AbstractConfigurationParser {
    private final YAMLFactory yamlFactory = new YAMLFactory();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public YamlConfigurationParser(IntegrationConfiguration configuration) {
        super(configuration);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object parse(Resource resource, Class<?> pluginConfigClass) {
        try (InputStream inputStream = resource.getInputStream();){
            YAMLParser yamlParser = this.yamlFactory.createParser(inputStream);
            JsonNode node = (JsonNode)this.objectMapper.readTree((JsonParser)yamlParser);
            if (node == null) {
                Object obj = pluginConfigClass.newInstance();
                return obj;
            }
            TreeTraversingParser treeTraversingParser = new TreeTraversingParser(node);
            Object object = this.objectMapper.readValue((JsonParser)treeTraversingParser, pluginConfigClass);
            return object;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new PluginException(e);
        }
    }
}

