/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.application;

import com.github.codingdebugallday.extension.AbstractExtension;
import com.github.codingdebugallday.extension.ExtensionFactory;
import com.github.codingdebugallday.integration.IntegrationConfiguration;
import com.github.codingdebugallday.integration.application.PluginApplication;
import com.github.codingdebugallday.integration.listener.PluginListener;
import com.github.codingdebugallday.integration.listener.PluginListenerFactory;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public abstract class AbstractPluginApplication
implements PluginApplication {
    protected final PluginListenerFactory listenerFactory = new PluginListenerFactory();

    @Override
    public void addExtension(AbstractExtension extension) {
        if (extension == null) {
            return;
        }
        extension.setPluginApplication(this);
        ExtensionFactory.addExtension(extension);
    }

    @Override
    public void addListener(PluginListener pluginListener) {
        this.listenerFactory.addPluginListener(pluginListener);
    }

    @Override
    public <T extends PluginListener> void addListener(Class<T> pluginListenerClass) {
        this.listenerFactory.addPluginListener(pluginListenerClass);
    }

    @Override
    public void addListener(List<PluginListener> pluginListeners) {
        if (pluginListeners == null || pluginListeners.isEmpty()) {
            return;
        }
        for (PluginListener pluginListener : pluginListeners) {
            this.listenerFactory.addPluginListener(pluginListener);
        }
    }

    protected IntegrationConfiguration getConfiguration(ApplicationContext applicationContext) {
        IntegrationConfiguration configuration = null;
        try {
            configuration = (IntegrationConfiguration)applicationContext.getBean(IntegrationConfiguration.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configuration == null) {
            throw new BeanCreationException("Not Found IntegrationConfiguration, Please define IntegrationConfiguration to Spring Bean.");
        }
        return configuration;
    }
}

