/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.application;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.integration.IntegrationConfiguration;
import com.github.codingdebugallday.integration.application.AbstractPluginApplication;
import com.github.codingdebugallday.integration.listener.PluginInitializerListener;
import com.github.codingdebugallday.integration.operator.DefaultPluginOperator;
import com.github.codingdebugallday.integration.operator.PluginOperator;
import com.github.codingdebugallday.integration.pf4j.DefaultPf4jFactory;
import com.github.codingdebugallday.integration.pf4j.Pf4jFactory;
import com.github.codingdebugallday.integration.user.DefaultPluginUser;
import com.github.codingdebugallday.integration.user.PluginUser;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DefaultPluginApplication
extends AbstractPluginApplication {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Pf4jFactory integrationFactory;
    private PluginUser pluginUser;
    private PluginOperator pluginOperator;
    private final AtomicBoolean beInitialized = new AtomicBoolean(false);

    public DefaultPluginApplication() {
    }

    public DefaultPluginApplication(Pf4jFactory integrationFactory) {
        this.integrationFactory = integrationFactory;
    }

    @Override
    public synchronized void initialize(ApplicationContext applicationContext, PluginInitializerListener listener) {
        Objects.requireNonNull(applicationContext, "ApplicationContext can't be null");
        if (this.beInitialized.get()) {
            throw new PluginException("Plugin has been initialized");
        }
        IntegrationConfiguration configuration = this.getConfiguration(applicationContext);
        if (this.integrationFactory == null) {
            this.integrationFactory = new DefaultPf4jFactory(configuration);
        }
        PluginManager pluginManager = this.integrationFactory.getPluginManager();
        this.pluginUser = this.createPluginUser(applicationContext, pluginManager);
        this.pluginOperator = this.createPluginOperator(applicationContext, pluginManager, configuration);
        try {
            this.pluginOperator.initPlugins(listener);
            this.beInitialized.set(true);
        }
        catch (Exception e) {
            this.log.error("initPlugins error,", (Throwable)e);
        }
    }

    protected PluginUser createPluginUser(ApplicationContext applicationContext, PluginManager pluginManager) {
        return new DefaultPluginUser(applicationContext, pluginManager);
    }

    protected PluginOperator createPluginOperator(ApplicationContext applicationContext, PluginManager pluginManager, IntegrationConfiguration configuration) {
        return new DefaultPluginOperator(applicationContext, configuration, pluginManager, this.listenerFactory);
    }

    @Override
    public PluginOperator getPluginOperator() {
        this.assertInjected();
        return this.pluginOperator;
    }

    @Override
    public PluginUser getPluginUser() {
        this.assertInjected();
        return this.pluginUser;
    }

    private void assertInjected() {
        if (this.pluginUser == null) {
            throw new PluginException("PluginUser is null, Please check whether the DefaultPluginApplication is injected");
        }
        if (this.pluginOperator == null) {
            throw new PluginException("PluginOperator is null, Please check whether the DefaultPluginApplication is injected");
        }
    }
}

