/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.operator;

import com.github.codingdebugallday.constants.BaseConstants;
import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.factory.DefaultPluginFactory;
import com.github.codingdebugallday.factory.PluginFactory;
import com.github.codingdebugallday.integration.IntegrationConfiguration;
import com.github.codingdebugallday.integration.listener.PluginInitializerListener;
import com.github.codingdebugallday.integration.listener.PluginInitializerListenerFactory;
import com.github.codingdebugallday.integration.listener.PluginListenerFactory;
import com.github.codingdebugallday.integration.operator.PluginOperator;
import com.github.codingdebugallday.integration.operator.module.PluginInfo;
import com.github.codingdebugallday.integration.operator.verify.DefaultPluginVerify;
import com.github.codingdebugallday.integration.operator.verify.PluginLegalVerify;
import com.github.codingdebugallday.utils.GlobalRegistryInfo;
import com.github.codingdebugallday.utils.PluginFileUtils;
import com.github.codingdebugallday.utils.PluginOperatorInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.pf4j.RuntimeMode;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class DefaultPluginOperator
implements PluginOperator {
    private boolean isInit = false;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern(BaseConstants.Pattern.NONE_DATETIME);
    protected final IntegrationConfiguration integrationConfiguration;
    protected final PluginManager pluginManager;
    protected final PluginFactory pluginFactory;
    protected final PluginInitializerListenerFactory pluginInitializerListenerFactory;
    protected PluginLegalVerify pluginLegalVerify;

    public DefaultPluginOperator(ApplicationContext applicationContext, IntegrationConfiguration integrationConfiguration, PluginManager pluginManager, PluginListenerFactory pluginListenerFactory) {
        Objects.requireNonNull(integrationConfiguration, "IntegrationConfiguration can't be null");
        Objects.requireNonNull(pluginManager, "PluginManager can't be null");
        this.integrationConfiguration = integrationConfiguration;
        this.pluginManager = pluginManager;
        this.pluginFactory = new DefaultPluginFactory(applicationContext, pluginListenerFactory);
        this.pluginInitializerListenerFactory = new PluginInitializerListenerFactory(applicationContext);
        this.pluginLegalVerify = new DefaultPluginVerify(pluginManager);
    }

    public void setUploadPluginVerify(PluginLegalVerify uploadPluginVerify) {
        if (uploadPluginVerify != null) {
            this.pluginLegalVerify = uploadPluginVerify;
        }
    }

    @Override
    public synchronized void initPlugins(PluginInitializerListener pluginInitializerListener) {
        if (this.isInit) {
            throw new PluginException("Plugins Already initialized. Cannot be initialized again");
        }
        try {
            PluginFileUtils.cleanEmptyFile(this.pluginManager.getPluginsRoot());
            this.pluginInitializerListenerFactory.addPluginInitializerListeners(pluginInitializerListener);
            this.log.info("Plugins start initialize of root path '{}'", (Object)this.pluginManager.getPluginsRoot());
            this.pluginInitializerListenerFactory.before();
            this.pluginFactory.initialize();
            this.pluginManager.loadPlugins();
            this.pluginManager.startPlugins();
            List pluginWrappers = this.pluginManager.getStartedPlugins();
            if (pluginWrappers == null || pluginWrappers.isEmpty()) {
                this.log.warn("Not found plugin!");
                return;
            }
            boolean isFoundException = false;
            for (PluginWrapper pluginWrapper : pluginWrappers) {
                String pluginId = pluginWrapper.getPluginId();
                GlobalRegistryInfo.addOperatorPluginInfo(pluginId, PluginOperatorInfo.OperatorType.INSTALL, false);
                isFoundException = this.register(pluginWrapper, pluginId);
            }
            this.pluginFactory.build();
            this.isInit = true;
            if (isFoundException) {
                this.log.error("Plugins initialize failure");
            } else {
                this.log.info("Plugins initialize success");
                this.pluginInitializerListenerFactory.complete();
            }
        }
        catch (Exception e) {
            this.pluginInitializerListenerFactory.failure(e);
            throw e;
        }
    }

    private boolean register(PluginWrapper pluginWrapper, String pluginId) {
        boolean isFoundException = false;
        try {
            this.pluginFactory.register(pluginWrapper);
        }
        catch (Exception e) {
            this.log.error("Plugin '{}' registry failure. Reason : {}", new Object[]{pluginId, e.getMessage(), e});
            isFoundException = true;
        }
        return isFoundException;
    }

    @Override
    public boolean install(Path path) {
        if (this.isDev()) {
            throw new PluginException("Plugin cannot be installed in 'dev' environment");
        }
        if (path == null) {
            throw new IllegalArgumentException("Method:install param 'pluginId' can not be empty");
        }
        String pluginId = null;
        try {
            pluginId = this.load(path);
            if (StringUtils.isEmpty((Object)pluginId)) {
                this.log.error("Plugin '{}' install failure, this plugin id is empty.", (Object)pluginId);
                boolean bl = false;
                return bl;
            }
            GlobalRegistryInfo.addOperatorPluginInfo(pluginId, PluginOperatorInfo.OperatorType.INSTALL, true);
            if (this.start(pluginId)) {
                this.log.info("Plugin '{}' install success", (Object)pluginId);
                boolean bl = true;
                return bl;
            }
            this.log.error("Plugin '{}' install failure", (Object)pluginId);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (!StringUtils.isEmpty((Object)pluginId)) {
                this.log.error("Plugin '{}' install failure. {}", (Object)pluginId, (Object)e.getMessage());
                this.log.info("Start uninstall plugin '{}' failure", (Object)pluginId);
                try {
                    this.uninstall(pluginId, false);
                }
                catch (Exception uninstallException) {
                    this.log.error("Plugin '{}' uninstall failure. {}", (Object)pluginId, (Object)uninstallException.getMessage());
                }
            }
            throw new PluginException(e);
        }
        finally {
            if (!StringUtils.isEmpty((Object)pluginId)) {
                GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
            }
        }
    }

    private String load(Path path) throws IOException {
        String pluginId;
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Not found this path " + path);
        }
        this.pluginLegalVerify.verify(path);
        Path pluginsRoot = this.pluginManager.getPluginsRoot();
        if (path.getParent().compareTo(pluginsRoot) == 0) {
            pluginId = this.pluginManager.loadPlugin(path);
        } else {
            File sourceFile = path.toFile();
            String targetPathString = pluginsRoot.toString() + File.separator + sourceFile.getName();
            Path targetPath = Paths.get(targetPathString, new String[0]);
            if (Files.exists(targetPath, new LinkOption[0])) {
                this.backup(targetPath, "install-backup", 1);
            }
            PluginFileUtils.createExistFile(targetPath);
            Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
            pluginId = this.pluginManager.loadPlugin(targetPath);
        }
        return pluginId;
    }

    @Override
    public boolean uninstall(String pluginId, boolean isBackup) {
        if (StringUtils.isEmpty((Object)pluginId)) {
            throw new IllegalArgumentException("Method:uninstall param 'pluginId' can not be empty");
        }
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw new PluginException("Plugin uninstall failure, Not found plugin '" + pluginId + "'");
        }
        if (pluginWrapper.getPluginState() == PluginState.STARTED) {
            try {
                this.pluginFactory.unregister(pluginId);
                this.pluginFactory.build();
            }
            catch (Exception e) {
                this.log.error("Plugin '{}' uninstall failure, {}", (Object)pluginId, (Object)e.getMessage());
            }
        }
        try {
            if (this.pluginManager.unloadPlugin(pluginId)) {
                Path pluginPath = pluginWrapper.getPluginPath();
                if (isBackup) {
                    this.backup(pluginPath, "uninstall", 1);
                } else {
                    Files.deleteIfExists(pluginPath);
                }
                this.log.info("Plugin '{}' uninstall success", (Object)pluginId);
                return true;
            }
            this.log.error("Plugin '{}' uninstall failure", (Object)pluginId);
            return false;
        }
        catch (IOException e) {
            String error = String.format("Plugin '%s' uninstall failure: %s", pluginId, e.getMessage());
            this.log.error(error);
            throw new PluginException(error, e);
        }
    }

    @Override
    public boolean start(String pluginId) {
        if (StringUtils.isEmpty((Object)pluginId)) {
            throw new IllegalArgumentException("Method:start param 'pluginId' can not be empty");
        }
        PluginWrapper pluginWrapper = this.getPluginWrapper(pluginId, "Start");
        if (pluginWrapper.getPluginState() == PluginState.STARTED) {
            throw new PluginException("This plugin '" + pluginId + "' have already started");
        }
        try {
            PluginState pluginState = this.pluginManager.startPlugin(pluginId);
            if (pluginState == PluginState.STARTED) {
                GlobalRegistryInfo.addOperatorPluginInfo(pluginId, PluginOperatorInfo.OperatorType.START, false);
                this.pluginFactory.register(pluginWrapper);
                this.pluginFactory.build();
                this.log.info("Plugin '{}' start success", (Object)pluginId);
                return true;
            }
            this.log.error("Plugin '{}' start failure, plugin state is not start. Current plugin state is '{}'", (Object)pluginId, (Object)pluginState);
        }
        catch (Exception e) {
            String error = String.format("Plugin '%s' start failure: %s", pluginId, e.getMessage());
            this.log.error(error);
            this.log.info("Start stop plugin {}", (Object)pluginId);
            try {
                this.stop(pluginId);
            }
            catch (Exception stopException) {
                this.log.error("Plugin '{}' stop failure: {}", (Object)pluginId, (Object)stopException.getMessage());
            }
            throw new PluginException(e);
        }
        return false;
    }

    @Override
    public boolean stop(String pluginId) {
        if (StringUtils.isEmpty((Object)pluginId)) {
            throw new IllegalArgumentException("Method:stop param 'pluginId' can not be empty");
        }
        PluginWrapper pluginWrapper = this.getPluginWrapper(pluginId, "Stop");
        if (pluginWrapper.getPluginState() != PluginState.STARTED) {
            throw new PluginException("This plugin '" + pluginId + "' is not started");
        }
        try {
            this.pluginFactory.unregister(pluginId);
            this.pluginFactory.build();
        }
        catch (Exception e) {
            this.log.error("Plugin '{}' stop failure. {}", (Object)pluginId, (Object)e.getMessage());
        }
        try {
            this.pluginManager.stopPlugin(pluginId);
            this.log.info("Plugin '{}' stop success", (Object)pluginId);
            return true;
        }
        catch (Exception e) {
            String error = String.format("Plugin '%s' stop failure: %s", pluginId, e.getMessage());
            this.log.error(error);
            throw new PluginException(e);
        }
    }

    @Override
    public boolean uploadPluginAndStart(MultipartFile pluginFile) {
        if (this.isDev()) {
            throw new PluginException("Plugin cannot be installed in the 'dev' environment");
        }
        if (pluginFile == null) {
            throw new IllegalArgumentException("Method:uploadPluginAndStart param 'pluginFile' can not be null");
        }
        Path path = this.uploadPlugin(pluginFile);
        if (this.install(path)) {
            this.log.info("Plugin upload and start success");
            return true;
        }
        this.log.error("Plugin upload and start failure");
        return false;
    }

    @Override
    public boolean installConfigFile(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new PluginException("path ' " + path + "'  does not exist!");
        }
        File sourceFile = path.toFile();
        String configPath = this.integrationConfiguration.pluginConfigFilePath() + File.separator + sourceFile.getName();
        try {
            Path targetPath = PluginFileUtils.createExistFile(Paths.get(configPath, new String[0]));
            if (Files.exists(targetPath, new LinkOption[0])) {
                this.backup(targetPath, "install-config-backup", 1);
            }
            Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public boolean uploadConfigFile(MultipartFile configFile) {
        if (configFile == null) {
            throw new PluginException("Method:uploadConfigFile param 'configFile' can not be null");
        }
        String fileName = configFile.getOriginalFilename();
        String configPath = this.integrationConfiguration.pluginConfigFilePath() + File.separator + fileName;
        try {
            Path targetPath = PluginFileUtils.createExistFile(Paths.get(configPath, new String[0]));
            if (Files.exists(targetPath, new LinkOption[0])) {
                this.backup(targetPath, "upload-config-backup", 2);
            }
            Files.write(targetPath, configFile.getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public boolean backupPlugin(Path path, String sign) {
        Objects.requireNonNull(path);
        return this.backup(path, sign, 2);
    }

    @Override
    public boolean backupPlugin(String pluginId, String sign) {
        PluginWrapper wrapper = this.getPluginWrapper(pluginId, "BackupPlugin by pluginId");
        return this.backupPlugin(wrapper.getPluginPath(), sign);
    }

    @Override
    public List<PluginInfo> getPluginInfo() {
        List startedPlugins = this.pluginManager.getPlugins();
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>();
        if (startedPlugins == null) {
            return pluginInfos;
        }
        return startedPlugins.stream().filter(Objects::nonNull).map(this::getPluginInfo).collect(Collectors.toList());
    }

    @Override
    public PluginInfo getPluginInfo(String pluginId) {
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw new PluginException("Not found plugin '" + pluginId + "'");
        }
        return this.getPluginInfo(pluginWrapper);
    }

    private PluginInfo getPluginInfo(PluginWrapper pluginWrapper) {
        return new PluginInfo(pluginWrapper.getDescriptor(), pluginWrapper.getPluginState(), pluginWrapper.getPluginPath().toAbsolutePath().toString(), this.pluginManager.getRuntimeMode().toString());
    }

    @Override
    public Set<String> getPluginFilePaths() {
        RuntimeMode environment = this.integrationConfiguration.environment();
        HashSet<String> paths = new HashSet<String>();
        if (environment == RuntimeMode.DEVELOPMENT) {
            paths.add(this.integrationConfiguration.pluginPath());
            return paths;
        }
        List files = FileUtils.getJars((Path)Paths.get(this.integrationConfiguration.pluginPath(), new String[0]));
        return files.stream().filter(Objects::nonNull).map(File::getAbsolutePath).collect(Collectors.toSet());
    }

    @Override
    public List<PluginWrapper> getPluginWrapper() {
        return this.pluginManager.getPlugins();
    }

    @Override
    public PluginWrapper getPluginWrapper(String pluginId) {
        return this.pluginManager.getPlugin(pluginId);
    }

    protected Path uploadPlugin(MultipartFile pluginFile) {
        Path tempPath;
        if (pluginFile == null) {
            throw new IllegalArgumentException("Method:uploadPlugin param 'pluginFile' can not be null");
        }
        String fileName = pluginFile.getOriginalFilename();
        assert (fileName != null);
        String suffixName = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (StringUtils.isEmpty((Object)suffixName)) {
            throw new IllegalArgumentException("Invalid file type, please select .jar or .zip file");
        }
        if (!BaseConstants.Suffix.JAR.equalsIgnoreCase(suffixName) && !BaseConstants.Suffix.ZIP.equalsIgnoreCase(suffixName)) {
            throw new IllegalArgumentException("Invalid file type, please select .jar or .zip file");
        }
        String tempPathString = this.integrationConfiguration.uploadTempPath() + File.separator + fileName;
        try {
            tempPath = PluginFileUtils.createExistFile(Paths.get(tempPathString, new String[0]));
            Files.write(tempPath, pluginFile.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
        try {
            Path verifyPath = this.pluginLegalVerify.verify(tempPath);
            if (verifyPath != null) {
                String targetPathString = this.pluginManager.getPluginsRoot().toString() + File.separator + fileName;
                Path targetPluginPath = Paths.get(targetPathString, new String[0]);
                if (Files.exists(targetPluginPath, new LinkOption[0])) {
                    this.backup(targetPluginPath, "upload", 2);
                }
                Files.copy(verifyPath, targetPluginPath, StandardCopyOption.REPLACE_EXISTING);
                Files.deleteIfExists(tempPath);
                return targetPluginPath;
            }
            Exception exception = new Exception(fileName + " verify failure, verifyPath is null");
            this.verifyFailureDelete(tempPath, exception);
            throw exception;
        }
        catch (Exception e) {
            this.verifyFailureDelete(tempPath, e);
            throw new PluginException(e);
        }
    }

    protected PluginWrapper getPluginWrapper(String pluginId, String errorMsg) {
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw new PluginException(errorMsg + " -> Not found plugin " + pluginId);
        }
        return pluginWrapper;
    }

    protected void verifyFailureDelete(Path tempPluginFile, Exception e) {
        try {
            Files.deleteIfExists(tempPluginFile);
        }
        catch (IOException e1) {
            throw new PluginException("Verify failure and delete temp file failure : " + e.getMessage(), e);
        }
    }

    protected boolean backup(Path sourcePath, String sign, int type) {
        try {
            File sourceFile;
            Path target;
            if (this.isDev()) {
                return false;
            }
            if (sourcePath == null) {
                return false;
            }
            if (!Files.exists(sourcePath, new LinkOption[0])) {
                this.log.error("Path '{}' does not exist", (Object)sourcePath);
                return false;
            }
            String fileName = sourcePath.getFileName().toString();
            String targetName = this.integrationConfiguration.backupPath() + File.separator;
            if (!StringUtils.isEmpty((Object)sign)) {
                targetName = targetName + "[" + sign + "]";
            }
            if (!Files.exists((target = Paths.get((targetName = targetName + "[" + this.getNowTimeByFormat() + "]") + "_" + fileName, new String[0])).getParent(), new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
            }
            if ((sourceFile = sourcePath.toFile()).length() == 0L) {
                return true;
            }
            if (type == 1) {
                Files.move(sourcePath, target, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(sourcePath, target, StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }
        catch (IOException e) {
            this.log.error("Backup plugin jar '{}' failure. {}", new Object[]{sourcePath, e.getMessage(), e});
            return false;
        }
    }

    protected String getNowTimeByFormat() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return FORMAT.format(localDateTime);
    }

    protected boolean isDev() {
        return this.integrationConfiguration.environment() == RuntimeMode.DEVELOPMENT;
    }
}

