/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.pf4j;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.integration.IntegrationConfiguration;
import com.github.codingdebugallday.integration.pf4j.Pf4jFactory;
import com.github.codingdebugallday.integration.pf4j.ResolvePropertiesPluginDescriptorFinder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.pf4j.CompoundPluginDescriptorFinder;
import org.pf4j.CompoundPluginRepository;
import org.pf4j.DefaultPluginManager;
import org.pf4j.JarPluginRepository;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginManager;
import org.pf4j.PluginRepository;
import org.pf4j.RuntimeMode;

public class DefaultPf4jFactory
implements Pf4jFactory {
    private final IntegrationConfiguration configuration;

    public DefaultPf4jFactory(IntegrationConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public PluginManager getPluginManager() {
        if (this.configuration == null) {
            throw new NullPointerException("IntegrationConfiguration is null");
        }
        RuntimeMode environment = this.configuration.environment();
        if (environment == null) {
            throw new PluginException("Configuration RuntimeMode is null" + this.configuration.environment());
        }
        if (RuntimeMode.DEVELOPMENT == environment) {
            Path path = Paths.get(this.getDevPluginDir(this.configuration), new String[0]);
            return new DefaultPluginManager(path){

                public RuntimeMode getRuntimeMode() {
                    System.setProperty("pf4j.mode", RuntimeMode.DEVELOPMENT.toString());
                    return RuntimeMode.DEVELOPMENT;
                }

                protected PluginDescriptorFinder createPluginDescriptorFinder() {
                    return new CompoundPluginDescriptorFinder().add((PluginDescriptorFinder)new ResolvePropertiesPluginDescriptorFinder()).add((PluginDescriptorFinder)new ManifestPluginDescriptorFinder());
                }
            };
        }
        if (RuntimeMode.DEPLOYMENT == environment) {
            Path path = Paths.get(this.getProdPluginDir(this.configuration), new String[0]);
            return new DefaultPluginManager(path){

                protected PluginRepository createPluginRepository() {
                    return new CompoundPluginRepository().add((PluginRepository)new JarPluginRepository(this.getPluginsRoot()));
                }
            };
        }
        throw new PluginException("Not found run environment " + this.configuration.environment());
    }

    private String getDevPluginDir(IntegrationConfiguration configuration) {
        String pluginDir = configuration.pluginPath();
        if (Objects.equals("", pluginDir)) {
            pluginDir = "./plugins/";
        }
        return pluginDir;
    }

    private String getProdPluginDir(IntegrationConfiguration configuration) {
        String pluginDir = configuration.pluginPath();
        if (Objects.equals("", pluginDir)) {
            pluginDir = "plugins";
        }
        return pluginDir;
    }
}

