/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.refresh;

import com.github.codingdebugallday.integration.application.PluginApplication;
import com.github.codingdebugallday.integration.listener.PluginListener;
import java.lang.reflect.ParameterizedType;
import java.util.List;

public abstract class AbstractSpringBeanRefresh<T>
implements PluginListener {
    private List<T> beans;
    protected final Class<T> typeClass;
    protected final PluginApplication pluginApplication;

    public AbstractSpringBeanRefresh(PluginApplication pluginApplication) {
        this.pluginApplication = pluginApplication;
        pluginApplication.addListener(this);
        this.typeClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public void register(String pluginId) {
        this.beans = this.refresh();
        this.registerEvent(this.beans);
    }

    @Override
    public void unregister(String pluginId) {
        this.beans = this.refresh();
        this.unregisterEvent(this.beans);
    }

    @Override
    public void failure(String pluginId, Throwable throwable) {
    }

    protected void registerEvent(List<T> beans) {
    }

    protected void unregisterEvent(List<T> beans) {
    }

    protected List<T> refresh() {
        return this.pluginApplication.getPluginUser().getBeans(this.typeClass);
    }

    public List<T> getBeans() {
        return this.beans;
    }
}

