/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.user;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.factory.PluginInfoContainer;
import com.github.codingdebugallday.integration.user.PluginUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class DefaultPluginUser
implements PluginUser {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final GenericApplicationContext applicationContext;
    protected final PluginManager pluginManager;

    public DefaultPluginUser(ApplicationContext applicationContext, PluginManager pluginManager) {
        Objects.requireNonNull(applicationContext, "ApplicationContext can't be null");
        Objects.requireNonNull(pluginManager, "PluginManager can't be null");
        this.applicationContext = (GenericApplicationContext)applicationContext;
        this.pluginManager = pluginManager;
    }

    @Override
    public <T> T getBean(String name) {
        Object bean = this.applicationContext.getBean(name);
        return (T)bean;
    }

    @Override
    public <T> T getBean(Class<T> aClass) {
        return (T)this.applicationContext.getBean(aClass);
    }

    @Override
    public <T> T getPluginBean(String name) {
        if (this.isPluginBean(name)) {
            return this.getBean(name);
        }
        return null;
    }

    @Override
    public <T> List<T> getBeans(Class<T> aClass) {
        Map beansOfTypeMap = this.applicationContext.getBeansOfType(aClass);
        return new ArrayList(beansOfTypeMap.values());
    }

    @Override
    public <T> List<T> getMainBeans(Class<T> aClass) {
        Map beansOfTypeMap = this.applicationContext.getBeansOfType(aClass);
        ArrayList beans = new ArrayList();
        beansOfTypeMap.forEach((beanName, bean) -> {
            if (!this.isPluginBean((String)beanName)) {
                beans.add(bean);
            }
        });
        return beans;
    }

    @Override
    public <T> List<T> getPluginBeans(Class<T> aClass) {
        Map beansOfTypeMap = this.applicationContext.getBeansOfType(aClass);
        ArrayList beans = new ArrayList();
        beansOfTypeMap.forEach((beanName, bean) -> {
            if (this.isPluginBean((String)beanName)) {
                beans.add(bean);
            }
        });
        return beans;
    }

    @Override
    public <T> List<T> getPluginBeans(String pluginId, Class<T> aClass) {
        Map beansOfTypeMap = this.applicationContext.getBeansOfType(aClass);
        ArrayList beans = new ArrayList();
        beansOfTypeMap.forEach((beanName, bean) -> {
            if (PluginInfoContainer.existRegisterBeanName(pluginId, beanName)) {
                beans.add(bean);
            }
        });
        return beans;
    }

    @Override
    public <T> T generateNewInstance(T object) {
        if (object == null) {
            return null;
        }
        try {
            Object newObject = this.applicationContext.getDefaultListableBeanFactory().createBean(object.getClass());
            return (T)newObject;
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
    }

    @Override
    public <T> List<T> getPluginExtensions(Class<T> tClass) {
        return this.pluginManager.getExtensions(tClass);
    }

    protected boolean isPluginBean(String beanName) {
        if (beanName == null) {
            return false;
        }
        return PluginInfoContainer.existRegisterBeanName(beanName);
    }
}

