/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ResourceWrapper {
    private final List<Resource> resources = new ArrayList<Resource>();
    private final Set<String> classPackageNames = new HashSet<String>();
    private final Map<String, Object> extensions = new HashMap<String, Object>();

    public void addResource(Resource resource) {
        if (Objects.nonNull(resource)) {
            this.resources.add(resource);
        }
    }

    public void addResources(List<Resource> resources) {
        if (!CollectionUtils.isEmpty(resources)) {
            this.resources.addAll(resources);
        }
    }

    public List<Resource> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    public void addClassPackageName(String classFullName) {
        if (!StringUtils.isEmpty((Object)classFullName)) {
            this.classPackageNames.add(classFullName);
        }
    }

    public void addClassPackageNames(Set<String> classPackageNames) {
        if (!CollectionUtils.isEmpty(classPackageNames)) {
            this.classPackageNames.addAll(classPackageNames);
        }
    }

    public Set<String> getClassPackageNames() {
        return Collections.unmodifiableSet(this.classPackageNames);
    }

    public void addExtension(String key, Object value) {
        this.extensions.put(key, value);
    }

    public Object getExtension(String key) {
        return this.extensions.get(key);
    }
}

