/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.loader.load;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.loader.PluginResourceLoader;
import com.github.codingdebugallday.loader.ResourceWrapper;
import com.github.codingdebugallday.realize.BasePlugin;
import com.github.codingdebugallday.utils.OrderPriority;
import com.github.codingdebugallday.utils.ScanUtils;
import java.io.IOException;
import java.util.Set;
import org.pf4j.RuntimeMode;

public class PluginClassLoader
implements PluginResourceLoader {
    public static final String DEFAULT_KEY = "PluginClassProcess";

    @Override
    public String key() {
        return DEFAULT_KEY;
    }

    @Override
    public ResourceWrapper load(BasePlugin basePlugin) {
        RuntimeMode runtimeMode = basePlugin.getWrapper().getRuntimeMode();
        Set<String> classPackageName = null;
        try {
            if (runtimeMode == RuntimeMode.DEPLOYMENT) {
                classPackageName = ScanUtils.scanClassPackageName(basePlugin.scanPackage(), basePlugin.getWrapper().getPluginClassLoader());
            } else if (runtimeMode == RuntimeMode.DEVELOPMENT) {
                classPackageName = ScanUtils.scanClassPackageName(basePlugin.scanPackage(), ((Object)((Object)basePlugin)).getClass());
            }
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
        ResourceWrapper resourceWrapper = new ResourceWrapper();
        resourceWrapper.addClassPackageNames(classPackageName);
        return resourceWrapper;
    }

    @Override
    public void unload(BasePlugin basePlugin, ResourceWrapper resourceWrapper) {
    }

    @Override
    public OrderPriority order() {
        return OrderPriority.getHighPriority();
    }
}

