/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.utils;

import com.github.codingdebugallday.utils.PluginOperatorInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class GlobalRegistryInfo {
    private static final Map<String, PluginOperatorInfo> PLUGIN_OPERATOR_INFO_MAP = new ConcurrentHashMap<String, PluginOperatorInfo>();
    private static final Map<String, Object> EXTENSION_MAP = new ConcurrentHashMap<String, Object>();

    private GlobalRegistryInfo() {
    }

    public static void addOperatorPluginInfo(String pluginId, PluginOperatorInfo.OperatorType operatorType, boolean isLock) {
        PluginOperatorInfo operatorPluginInfo = PLUGIN_OPERATOR_INFO_MAP.computeIfAbsent(pluginId, k -> new PluginOperatorInfo());
        operatorPluginInfo.setOperatorType(operatorType);
        operatorPluginInfo.setLock(isLock);
    }

    public static void setOperatorPluginInfo(String pluginId, boolean isLock) {
        PluginOperatorInfo operatorPluginInfo = PLUGIN_OPERATOR_INFO_MAP.get(pluginId);
        if (operatorPluginInfo != null) {
            operatorPluginInfo.setLock(isLock);
        }
    }

    public static PluginOperatorInfo getPluginInstallNum(String pluginId) {
        return PLUGIN_OPERATOR_INFO_MAP.get(pluginId);
    }

    public static void addExtension(String key, Object value) {
        EXTENSION_MAP.put(key, value);
    }

    public static void removeExtension(String key) {
        EXTENSION_MAP.remove(key);
    }

    public static <T> T getExtension(String key) {
        Object o = EXTENSION_MAP.get(key);
        if (o == null) {
            return null;
        }
        return (T)o;
    }
}

