/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.utils;

public class OrderPriority {
    private static final Integer HIGH_PRIORITY = 1000;
    private static final Integer MIDDLE_PRIORITY = 0;
    private static final Integer LOW_PRIORITY = -1000;
    private Integer priority;

    private OrderPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public static OrderPriority getLowPriority() {
        return new OrderPriority(LOW_PRIORITY);
    }

    public static OrderPriority getMiddlePriority() {
        return new OrderPriority(MIDDLE_PRIORITY);
    }

    public static OrderPriority getHighPriority() {
        return new OrderPriority(HIGH_PRIORITY);
    }

    public OrderPriority up(Integer number) {
        if (number == null) {
            return this;
        }
        this.priority = HIGH_PRIORITY.equals(this.priority) || this.priority + number > HIGH_PRIORITY ? HIGH_PRIORITY : Integer.valueOf(this.priority + number);
        return this;
    }

    public OrderPriority down(Integer number) {
        if (number == null) {
            return this;
        }
        this.priority = MIDDLE_PRIORITY.equals(this.priority) || this.priority - number < MIDDLE_PRIORITY ? MIDDLE_PRIORITY : Integer.valueOf(this.priority - number);
        return this;
    }
}

