/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginFileUtils {
    private static final Logger log = LoggerFactory.getLogger(PluginFileUtils.class);

    private PluginFileUtils() {
        throw new IllegalStateException("util class");
    }

    public static String getMd5ByFile(File file) {
        String value = null;
        try (FileInputStream in = new FileInputStream(file);){
            MappedByteBuffer byteBuffer = in.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(byteBuffer);
            BigInteger bi = new BigInteger(1, md5.digest());
            value = bi.toString(16);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error("Md5 error,", (Throwable)e);
        }
        return value;
    }

    public static void cleanEmptyFile(Path path) {
        if (path == null) {
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.list(path);){
            stream.forEach(subPath -> {
                File file = subPath.toFile();
                if (!file.isFile()) {
                    return;
                }
                long length = file.length();
                if (length == 0L) {
                    try {
                        Files.deleteIfExists(subPath);
                    }
                    catch (IOException e) {
                        log.error("delete file error,", (Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            log.error("list file error,", (Throwable)e);
        }
    }

    public static Path createExistFile(Path path) throws IOException {
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        return path;
    }
}

