/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.utils;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.ClassUtils;

public class ScanUtils {
    private static final String WINDOWS_OS = "WINDOWS";
    private static final String JAVA_CLASS_SUFFIX = ".class";

    private ScanUtils() {
        throw new IllegalStateException("util class");
    }

    public static Set<String> scanClassPackageName(String basePackage, Class<?> baseClass) throws IOException {
        String osName = System.getProperty("os.name");
        if (osName.toUpperCase().startsWith(WINDOWS_OS)) {
            return ScanUtils.scanClassPackageNameOfWindows(basePackage, baseClass);
        }
        return ScanUtils.scanClassPackageNameOfOther(basePackage, baseClass);
    }

    private static Set<String> scanClassPackageNameOfWindows(String basePackage, Class<?> baseClass) throws IOException {
        String classpathRootPath = baseClass.getResource("/").getPath();
        String classpath = classpathRootPath.replace("/", "\\").replaceFirst("\\\\", "");
        basePackage = basePackage.replace(".", File.separator);
        String fullPath = classpath + basePackage;
        return ScanUtils.filterPath(fullPath).map(path -> {
            String pathString = path.toString();
            return pathString.replace(classpath, "").replace("\\", ".").replace(JAVA_CLASS_SUFFIX, "");
        }).collect(Collectors.toSet());
    }

    private static Set<String> scanClassPackageNameOfOther(String basePackage, Class<?> baseClass) throws IOException {
        String classpath = baseClass.getResource("/").getPath();
        String fullPath = classpath + ClassUtils.classPackageAsResourcePath(baseClass);
        return ScanUtils.filterPath(fullPath).map(path -> {
            String pathString = path.toString();
            pathString = pathString.replace(classpath, "").replace(JAVA_CLASS_SUFFIX, "");
            return ClassUtils.convertResourcePathToClassName((String)pathString);
        }).collect(Collectors.toSet());
    }

    private static Stream<Path> filterPath(String fullPath) throws IOException {
        return Files.walk(Paths.get(fullPath, new String[0]), new FileVisitOption[0]).filter(Objects::nonNull).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
            String fileName = path.getFileName().toString();
            if (fileName == null) {
                return false;
            }
            return fileName.endsWith(JAVA_CLASS_SUFFIX);
        });
    }

    public static Set<String> scanClassPackageName(String basePackage, ClassLoader classLoader) throws IOException {
        Enumeration<URL> urlEnumeration = classLoader.getResources(basePackage.replace(".", "/"));
        HashSet<String> classPackageNames = new HashSet<String>();
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            String protocol = url.getProtocol();
            if (!"jar".equalsIgnoreCase(protocol)) {
                return classPackageNames;
            }
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            if (connection == null) {
                return classPackageNames;
            }
            JarFile jarFile = connection.getJarFile();
            if (jarFile == null) {
                return classPackageNames;
            }
            Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
            while (jarEntryEnumeration.hasMoreElements()) {
                JarEntry entry = jarEntryEnumeration.nextElement();
                String jarEntryName = entry.getName();
                if (!jarEntryName.contains(JAVA_CLASS_SUFFIX) || !jarEntryName.replace("/", ".").startsWith(basePackage)) continue;
                String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(46)).replace("/", ".");
                classPackageNames.add(className);
            }
        }
        return classPackageNames;
    }
}

