package com.github.collinalpert.java2db.database;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks a field as the correspondent to a foreign key in the database.
 * The parameter value has to match the corresponding {@link ForeignKeyObject} parameter value.
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ForeignKey {
	int value();
}
