/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.services;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.database.TableName;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.BaseMapper;
import com.github.collinalpert.java2db.utilities.Lambda2Sql;
import com.github.collinalpert.java2db.utilities.SqlPredicate;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BaseService<T extends BaseEntity> {
    private final String typeName;
    private final String tableName;
    private BaseMapper<T> mapper;

    public BaseService(Class<T> clazz) {
        this.mapper = new BaseMapper<T>(clazz);
        this.typeName = clazz.getSimpleName();
        TableName tableNameAnnotation = clazz.getAnnotation(TableName.class);
        if (tableNameAnnotation == null) {
            this.tableName = this.typeName.toLowerCase();
            return;
        }
        this.tableName = tableNameAnnotation.value();
    }

    public void create(T instance) throws SQLException {
        StringBuilder insertQuery = new StringBuilder("insert into `").append(this.tableName).append("` (");
        String databaseFields = Utilities.getAllFields(instance).stream().map(Field::getName).collect(Collectors.joining(", "));
        insertQuery.append(databaseFields).append(") values");
        ArrayList<String> values = new ArrayList<String>();
        Utilities.getAllFields(instance, BaseEntity.class).forEach(field -> {
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                if (value == null) {
                    values.add("default");
                    return;
                }
                if (value instanceof String) {
                    values.add(String.format("'%s'", value));
                    return;
                }
                if (value instanceof Boolean) {
                    boolean bool = (Boolean)value;
                    values.add(Integer.toString(bool ? 1 : 0));
                    return;
                }
                if (value instanceof LocalDateTime) {
                    LocalDateTime dateTime = (LocalDateTime)value;
                    values.add(String.format("'%d-%d-%d %d:%d:%d'", dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond()));
                    return;
                }
                if (value instanceof LocalDate) {
                    LocalDate date = (LocalDate)value;
                    values.add(String.format("'%d-%d-%d'", date.getYear(), date.getMonthValue(), date.getDayOfMonth()));
                    return;
                }
                if (value instanceof LocalTime) {
                    LocalTime time = (LocalTime)value;
                    values.add(String.format("'%d:%d:%d'", time.getHour(), time.getMinute(), time.getSecond()));
                    return;
                }
                values.add(value.toString());
            }
            catch (IllegalAccessException e) {
                System.err.printf("Unable to get value from field %s for type %s\n", field.getName(), this.typeName);
            }
        });
        values.add("default");
        insertQuery.append(" (").append(String.join((CharSequence)", ", values)).append(")");
        Utilities.log(insertQuery.toString());
        try (DBConnection connection = new DBConnection();){
            connection.update(insertQuery.toString());
            Utilities.logf("%s successfully created!", this.typeName);
        }
    }

    private ResultSet getByPredicate(SqlPredicate<T> predicate, DBConnection connection) throws SQLException {
        String query = String.format("select * from `%s` where %s", this.tableName, Lambda2Sql.toSql(predicate));
        Utilities.log(query);
        return connection.execute(query);
    }

    protected Optional<T> getSingle(SqlPredicate<T> predicate) {
        Optional<T> optional;
        DBConnection connection = new DBConnection();
        Throwable throwable = null;
        try {
            optional = this.mapper.map(this.getByPredicate(predicate, connection));
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    BaseService.$closeResource(throwable, connection);
                    throw throwable3;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
        BaseService.$closeResource(throwable, connection);
        return optional;
    }

    protected List<T> getMultiple(SqlPredicate<T> predicate) {
        List<T> list;
        DBConnection connection = new DBConnection();
        Throwable throwable = null;
        try {
            list = this.mapper.mapToList(this.getByPredicate(predicate, connection));
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    BaseService.$closeResource(throwable, connection);
                    throw throwable3;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        BaseService.$closeResource(throwable, connection);
        return list;
    }

    public Optional<T> getById(long id) {
        return this.getSingle(x -> x.getId() == id);
    }

    public List<T> getAll() {
        return this.getMultiple(x -> true);
    }

    public void update(T instance) throws SQLException {
        StringBuilder updateQuery = new StringBuilder("update `").append(this.tableName).append("` set ");
        ArrayList fieldSetterList = new ArrayList();
        Utilities.getAllFields(instance, BaseEntity.class).forEach(field -> {
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                if (value == null) {
                    fieldSetterList.add(String.format("%s = default", field.getName()));
                }
                if (value instanceof String) {
                    fieldSetterList.add(String.format("%s = '%s'", field.getName(), value));
                    return;
                }
                if (value instanceof Boolean) {
                    boolean bool = (Boolean)value;
                    fieldSetterList.add(String.format("%s = %d", field.getName(), bool ? 1 : 0));
                    return;
                }
                if (value instanceof LocalDateTime) {
                    LocalDateTime dateTime = (LocalDateTime)value;
                    fieldSetterList.add(String.format("%s = '%d-%d-%d %d:%d:%d'", field.getName(), dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond()));
                    return;
                }
                if (value instanceof LocalDate) {
                    LocalDate date = (LocalDate)value;
                    fieldSetterList.add(String.format("%s = '%d-%d-%d'", field.getName(), date.getYear(), date.getMonthValue(), date.getDayOfMonth()));
                    return;
                }
                if (value instanceof LocalTime) {
                    LocalTime time = (LocalTime)value;
                    fieldSetterList.add(String.format("%s = '%d:%d:%d'", field.getName(), time.getHour(), time.getMinute(), time.getSecond()));
                    return;
                }
                fieldSetterList.add(field.getName() + " = " + value);
            }
            catch (IllegalAccessException e) {
                System.err.printf("Error getting value for field %s from type %s\n", field.getName(), this.typeName);
            }
        });
        updateQuery.append(String.join((CharSequence)", ", fieldSetterList)).append(" where id = ").append(((BaseEntity)instance).getId());
        Utilities.log(updateQuery.toString());
        try (DBConnection connection = new DBConnection();){
            connection.update(updateQuery.toString());
            Utilities.logf("%s with id %d was successfully updated", this.typeName, ((BaseEntity)instance).getId());
        }
    }

    public void delete(T instance) {
        this.delete(((BaseEntity)instance).getId());
    }

    public void delete(long id) {
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("delete from `%s` where id=?", this.tableName), id);
            Utilities.logf("%s with id %d successfully deleted!", this.typeName, id);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

