/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionType;
import com.trigersoft.jaque.expression.ExpressionVisitor;

public class UnaryExpression
extends Expression {
    private final Expression _operand;

    UnaryExpression(int expressionType, Class<?> resultType, Expression operand) {
        super(expressionType, resultType);
        if (operand == null) {
            throw new NullPointerException("operand");
        }
        this._operand = operand;
    }

    public final Expression getFirst() {
        return this._operand;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._operand == null ? 0 : this._operand.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryExpression other = (UnaryExpression)obj;
        return !(this._operand == null ? other._operand != null : !this._operand.equals(other._operand));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.getExpressionType() == 8) {
            b.append('(');
            b.append(this.getResultType().getName());
            b.append(')');
        } else {
            b.append(ExpressionType.toString(this.getExpressionType()));
        }
        b.append(this.getFirst().toString());
        return b.toString();
    }
}

