/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.utilities;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.services.BaseService;
import com.github.collinalpert.java2db.utilities.SqlPredicate;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class IoC {
    private static Map<Class<? extends BaseEntity>, BaseService<? extends BaseEntity>> services = new HashMap<Class<? extends BaseEntity>, BaseService<? extends BaseEntity>>();
    private static Map<Class<? extends BaseEntity>, SqlPredicate<? extends BaseEntity>> selectConstraints = new HashMap<Class<? extends BaseEntity>, SqlPredicate<? extends BaseEntity>>();

    public static <E> E resolve(Class<E> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("Class %s could not be instantiated.", clazz.getSimpleName()));
        }
    }

    public static <E extends BaseEntity, S extends BaseService<E>> S resolveService(Class<S> clazz) {
        Optional<BaseService> service = services.values().stream().filter(x -> x.getClass().equals(clazz)).findFirst();
        if (!service.isPresent()) {
            throw new IllegalArgumentException(String.format("An instance of the service %s has not been registered yet. Please use the \"registerService\" method.", clazz.getSimpleName()));
        }
        return (S)((BaseService)clazz.cast(service.get()));
    }

    public static <E extends BaseEntity, S extends BaseService<E>> S resolveServiceByEntity(Class<E> clazz) {
        if (!services.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("An instance of a service for the entity %s has not been registered yet. Please use the \"registerService\" method.", clazz.getSimpleName()));
        }
        return (S)services.get(clazz);
    }

    public static <E extends BaseEntity, S extends BaseService<E>> void registerService(Class<E> clazz, S service) {
        services.put(clazz, service);
    }

    public static <E extends BaseEntity> void addConstraint(Class<E> clazz, SqlPredicate<E> predicate) {
        selectConstraints.put(clazz, predicate);
    }

    public <E extends BaseEntity, S extends BaseService<E>> boolean isRegistered(Class<S> clazz) {
        return services.values().stream().anyMatch(x -> x.getClass() == clazz);
    }
}

