/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.mappers;

import com.github.collinalpert.java2db.annotations.ColumnName;
import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.Mapper;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.UniqueIdentifier;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;

public class BaseMapper<T extends BaseEntity>
implements Mapper<T> {
    private Class<T> clazz;

    public BaseMapper(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Optional<T> map(ResultSet set) throws SQLException {
        BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
        if (!set.next()) {
            UniqueIdentifier.unset();
            return Optional.empty();
        }
        this.setFields(set, entity);
        set.close();
        UniqueIdentifier.unset();
        return Optional.of(entity);
    }

    @Override
    public List<T> mapToList(ResultSet set) throws SQLException {
        LinkedList<BaseEntity> list = new LinkedList<BaseEntity>();
        while (set.next()) {
            BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
            this.setFields(set, entity);
            list.add(entity);
        }
        set.close();
        UniqueIdentifier.unset();
        return list;
    }

    @Override
    public Stream<T> mapToStream(ResultSet set) throws SQLException {
        Stream<Object> stream = Stream.empty();
        while (set.next()) {
            BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
            this.setFields(set, entity);
            stream = Stream.concat(stream, Stream.of(entity));
        }
        set.close();
        UniqueIdentifier.unset();
        return stream;
    }

    private <E extends BaseEntity> void setFields(ResultSet set, E entity) throws SQLException {
        this.setFields(set, entity, null);
    }

    private <E extends BaseEntity> void setFields(ResultSet set, E entity, String identifier) throws SQLException {
        List<Field> fields = Utilities.getEntityFields(entity.getClass(), true);
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.getAnnotation(ForeignKeyEntity.class) != null) {
                String foreignKeyName;
                block10: {
                    String foreignKeyColumnName = field.getAnnotation(ForeignKeyEntity.class).value();
                    if (!BaseEntity.class.isAssignableFrom(field.getType())) {
                        throw new IllegalArgumentException(String.format("Type %s which is annotated as a foreign key, does not extend BaseEntity", field.getType().getSimpleName()));
                    }
                    foreignKeyName = "";
                    try {
                        Field foreignKeyField = field.getDeclaringClass().getDeclaredField(foreignKeyColumnName);
                        foreignKeyName = foreignKeyField.getName();
                        if (foreignKeyField.getAnnotation(ColumnName.class) == null) break block10;
                        foreignKeyName = foreignKeyField.getAnnotation(ColumnName.class).value();
                    }
                    catch (NoSuchFieldException e) {
                        for (Field declaredField : field.getDeclaringClass().getDeclaredFields()) {
                            if (declaredField.getAnnotation(ColumnName.class) == null || !declaredField.getAnnotation(ColumnName.class).value().equals(foreignKeyColumnName)) continue;
                            foreignKeyName = declaredField.getAnnotation(ColumnName.class).value();
                            break;
                        }
                    }
                }
                if (set.getObject((identifier == null ? Utilities.getTableName(entity.getClass()) : identifier) + "_" + foreignKeyName) == null) continue;
                BaseEntity foreignKeyObject = (BaseEntity)IoC.resolve(field.getType());
                this.setFields(set, foreignKeyObject, UniqueIdentifier.getIdentifier(field.getName()));
                try {
                    field.set(entity, foreignKeyObject);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
            String columnName = Utilities.getColumnName(field);
            String columnLabel = (identifier == null ? Utilities.getTableName(entity.getClass()) : identifier) + "_" + columnName;
            Object value = field.getType() == LocalDateTime.class ? set.getTimestamp(columnLabel, Calendar.getInstance(Locale.getDefault())).toLocalDateTime() : (field.getType() == LocalDate.class ? set.getDate(columnLabel, Calendar.getInstance(Locale.getDefault())).toLocalDate() : (field.getType() == LocalTime.class ? set.getTime(columnLabel, Calendar.getInstance(Locale.getDefault())).toLocalTime() : set.getObject(columnLabel)));
            if (value == null) continue;
            try {
                field.set(entity, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

