/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.expressions.function;

import com.github.collinalpert.expressions.function.math.BinaryOperator;
import com.github.collinalpert.expressions.function.math.UnaryOperator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Functions {
    private Functions() {
    }

    public static <T> Function<T, Number> abs(Function<T, ? extends Number> selector) {
        return selector.andThen(UnaryOperator.Abs::eval);
    }

    public static <N extends Number> Function<N, Number> abs() {
        return Functions.abs(Function.identity());
    }

    public static Function<?, Number> negate(Function<?, ? extends Number> selector) {
        return selector.andThen(UnaryOperator.Negate::eval);
    }

    public static Function<?, Number> negate() {
        return Functions.negate(Function.identity());
    }

    public static Function<?, Number> bitwiseNot(Function<?, ? extends Number> selector) {
        return selector.andThen(UnaryOperator.Not::eval);
    }

    public static Function<?, Number> bitwiseNot() {
        return Functions.bitwiseNot(Function.identity());
    }

    public static <T, U> BiFunction<T, U, Number> bitwiseAnd(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.And.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> add(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.Add.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> subtract(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.Subtract.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> multiply(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.Multiply.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> divide(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.Divide.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> modulo(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.Modulo.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> bitwiseOr(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.Or.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> power(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.Power.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> shiftLeft(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.ShiftLeft.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> shiftRight(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.ShiftRight.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiFunction<T, U, Number> xor(Function<T, ? extends Number> left, Function<U, ? extends Number> right) {
        return (t, u) -> BinaryOperator.Xor.eval((Number)left.apply(t), (Number)right.apply(u));
    }

    public static <T, U> BiPredicate<T, U> and(Predicate<T> left, Predicate<U> right) {
        return (t, u) -> left.test(t) && right.test(u);
    }

    public static <T, U> BiPredicate<T, U> and(Function<T, Boolean> left, Function<U, Boolean> right) {
        return Functions.and(left::apply, right::apply);
    }

    public static <T, U> BiPredicate<T, U> or(Predicate<T> left, Predicate<U> right) {
        return (t, u) -> left.test(t) || right.test(u);
    }

    public static <T, U> BiPredicate<T, U> or(Function<T, Boolean> left, Function<U, Boolean> right) {
        return Functions.or(left::apply, right::apply);
    }

    public static <T, U, Key extends Comparable<Key>> BiPredicate<T, U> lessThan(Function<T, Key> left, Function<U, Key> right) {
        return (t, u) -> {
            Comparable k1 = (Comparable)left.apply(t);
            Comparable k2 = (Comparable)right.apply(u);
            return k1 instanceof Number && k2 instanceof Number ? Objects.compare(k1, k2, (key1, key2) -> BinaryOperator.Subtract.eval((Number)((Object)key1), (Number)((Object)key2)).intValue()) < 0 : k1.compareTo(k2) < 0;
        };
    }

    public static <T, U, Key extends Comparable<Key>> BiPredicate<T, U> lessThanOrEqual(Function<T, Key> left, Function<U, Key> right) {
        return (t, u) -> {
            Comparable k1 = (Comparable)left.apply(t);
            Comparable k2 = (Comparable)right.apply(u);
            return k1 instanceof Number && k2 instanceof Number ? Objects.compare(k1, k2, (key1, key2) -> BinaryOperator.Subtract.eval((Number)((Object)key1), (Number)((Object)key2)).intValue()) <= 0 : k1.compareTo(k2) <= 0;
        };
    }

    public static <T, U> BiPredicate<T, U> equal(Function<T, ?> left, Function<U, ?> right) {
        return (t, u) -> Objects.equals(left.apply(t), right.apply(u));
    }

    public static <T, U, Key extends Comparable<Key>> BiPredicate<T, U> greaterThanOrEqual(Function<T, Key> left, Function<U, Key> right) {
        return (t, u) -> {
            Comparable k1 = (Comparable)left.apply(t);
            Comparable k2 = (Comparable)right.apply(u);
            return k1 instanceof Number && k2 instanceof Number ? Objects.compare(k1, k2, (key1, key2) -> BinaryOperator.Subtract.eval((Number)((Object)key1), (Number)((Object)key2)).intValue()) >= 0 : k1.compareTo(k2) >= 0;
        };
    }

    public static <T, U, Key extends Comparable<Key>> BiPredicate<T, U> greaterThan(Function<T, Key> left, Function<U, Key> right) {
        return (t, u) -> {
            Comparable k1 = (Comparable)left.apply(t);
            Comparable k2 = (Comparable)right.apply(u);
            return k1 instanceof Number && k2 instanceof Number ? Objects.compare(k1, k2, (key1, key2) -> BinaryOperator.Subtract.eval((Number)((Object)key1), (Number)((Object)key2)).intValue()) > 0 : k1.compareTo(k2) > 0;
        };
    }

    public static <T, Result> Function<T, Result> constant(Result result) {
        return t -> result;
    }

    public static <T, Result> Function<T, Result> property(Class<? super T> outerType, String propertyName) throws NoSuchMethodException {
        Method d = outerType.getDeclaredMethod("get" + propertyName, new Class[0]);
        return t -> {
            try {
                return d.invoke(t, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, Result> Function<T, Result> field(Class<? super T> outerType, String fieldName) throws NoSuchFieldException {
        Field d = outerType.getDeclaredField(fieldName);
        return t -> {
            try {
                return d.get(t);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <Result, T> Predicate<T> instanceOf(Function<? super T, ? extends Result> operand, Class<?> type) {
        return t -> type.isInstance(operand.apply(t));
    }

    public static <Result, T> Function<T, Result> iif(Function<? super T, Boolean> predicate, Function<? super T, ? extends Result> ifTrue, Function<? super T, ? extends Result> ifFalse) {
        return t -> (Boolean)predicate.apply(t) != false ? ifTrue.apply(t) : ifFalse.apply(t);
    }

    public static <T> Predicate<T> not(Function<T, Boolean> predicate) {
        Predicate<Object> p = predicate::apply;
        return p.negate();
    }
}

