/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.database;

import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.database.TableColumnReference;
import java.lang.reflect.Field;

public class ForeignKeyReference
extends TableColumnReference {
    private final String foreignKeyTableName;
    private final String foreignKeyColumnName;
    private final String foreignKeyAlias;
    private final ForeignKeyEntity.JoinTypes joinType;

    public ForeignKeyReference(String tableName, String alias, Field column, String foreignKeyTableName, String foreignKeyAlias, ForeignKeyEntity.JoinTypes joinType) {
        super(tableName, alias, column);
        this.foreignKeyTableName = foreignKeyTableName;
        this.foreignKeyColumnName = column.getAnnotation(ForeignKeyEntity.class).value();
        this.foreignKeyAlias = foreignKeyAlias;
        this.joinType = joinType;
    }

    public ForeignKeyReference(String tableName, String alias, Field column, String foreignKeyTableName, String foreignKeyAlias) {
        this(tableName, alias, column, foreignKeyTableName, foreignKeyAlias, ForeignKeyEntity.JoinTypes.LEFT);
    }

    public String getForeignKeyTableName() {
        return this.foreignKeyTableName;
    }

    public String getForeignKeyColumnName() {
        return this.foreignKeyColumnName;
    }

    public String getForeignKeyAlias() {
        return this.foreignKeyAlias;
    }

    public ForeignKeyEntity.JoinTypes getJoinType() {
        return this.joinType;
    }
}

