/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.modules.ArrayModule;
import com.github.collinalpert.java2db.queries.EntityQuery;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.java2db.queries.SingleEntityProjectionQuery;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class EntityProjectionQuery<E extends BaseEntity, R>
extends SingleEntityProjectionQuery<E, R>
implements Queryable<R> {
    public EntityProjectionQuery(SqlFunction<E, R> projection, EntityQuery<E> originalQuery) {
        super(projection, originalQuery);
    }

    @Override
    public Optional<R> first() {
        ((EntityQuery)this.originalQuery).limit(1);
        return super.first();
    }

    @Override
    public List<R> toList() {
        ArrayList list = new ArrayList();
        return this.resultHandling(list, List::add, Collections.emptyList(), Function.identity());
    }

    @Override
    public Stream<R> toStream() {
        Stream.Builder streamBuilder = Stream.builder();
        return this.resultHandling(streamBuilder, Stream.Builder::accept, Stream.empty(), Stream.Builder::build);
    }

    @Override
    public R[] toArray() {
        ArrayModule arrayModule = new ArrayModule(this.returnType, 20);
        Object[] defaultValue = (Object[])Array.newInstance(this.returnType, 0);
        return this.resultHandling(arrayModule, ArrayModule::addElement, defaultValue, ArrayModule::getArray);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <K, V> Map<K, V> toMap(Function<R, K> keyMapping, Function<R, V> valueMapping) {
        HashMap<K, V> map = new HashMap<K, V>();
        try (DBConnection connection = new DBConnection();){
            HashMap<K, V> hashMap;
            block14: {
                ResultSet result = connection.execute(this.getQuery());
                try {
                    while (result.next()) {
                        Object currentValue = result.getObject(1, this.returnType);
                        map.put(keyMapping.apply(currentValue), valueMapping.apply(currentValue));
                    }
                    hashMap = map;
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
    }

    @Override
    public Set<R> toSet() {
        return this.resultHandling(new HashSet(), Set::add, Collections.emptySet(), Function.identity());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T, D> T resultHandling(D dataStructure, BiConsumer<D, R> valueConsumer, T defaultValue, Function<D, T> valueMapping) {
        try (DBConnection connection = new DBConnection();){
            D d;
            block14: {
                ResultSet result = connection.execute(this.getQuery());
                try {
                    while (result.next()) {
                        valueConsumer.accept(dataStructure, result.getObject(1, this.returnType));
                    }
                    d = valueMapping.apply(dataStructure);
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return (T)d;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

