/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.EntityProjectionQuery;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.java2db.queries.SingleEntityQuery;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Stream;

public class EntityQuery<E extends BaseEntity>
extends SingleEntityQuery<E>
implements Queryable<E> {
    protected OrderTypes orderType = OrderTypes.ASCENDING;
    private List<SqlFunction<E, ?>> orderByClause;
    private Integer limit;
    private int limitOffset;

    public EntityQuery(Class<E> type) {
        super(type);
    }

    @Override
    public EntityQuery<E> where(SqlPredicate<E> predicate) {
        super.where(predicate);
        return this;
    }

    @Override
    public EntityQuery<E> orWhere(SqlPredicate<E> predicate) {
        super.orWhere(predicate);
        return this;
    }

    public EntityQuery<E> orderBy(SqlFunction<E, ?> function) {
        if (function == null) {
            return this;
        }
        return this.orderBy(Collections.singletonList(function));
    }

    public EntityQuery<E> orderBy(SqlFunction<E, ?>[] functions) {
        if (functions == null) {
            return this;
        }
        return this.orderBy(Arrays.asList(functions));
    }

    public EntityQuery<E> orderBy(List<SqlFunction<E, ?>> functions) {
        this.orderByClause = functions;
        return this;
    }

    public EntityQuery<E> orderBy(OrderTypes orderType, SqlFunction<E, ?> function) {
        if (function == null) {
            return this;
        }
        return this.orderBy(orderType, Collections.singletonList(function));
    }

    public EntityQuery<E> orderBy(OrderTypes orderType, SqlFunction<E, ?>[] functions) {
        if (functions == null) {
            return this;
        }
        return this.orderBy(orderType, Arrays.asList(functions));
    }

    public EntityQuery<E> orderBy(OrderTypes orderType, List<SqlFunction<E, ?>> functions) {
        this.orderType = orderType;
        this.orderByClause = functions;
        return this;
    }

    public EntityQuery<E> limit(int limit, int offset) {
        this.limit = limit;
        this.limitOffset = offset;
        return this;
    }

    public EntityQuery<E> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public <R> Queryable<R> project(SqlFunction<E, R> projection) {
        return new EntityProjectionQuery<E, R>(projection, this);
    }

    @Override
    public Optional<E> first() {
        this.limit(1);
        return super.first();
    }

    @Override
    public List<E> toList() {
        DBConnection connection = new DBConnection();
        try {
            List list = this.mapper.mapToList(connection.execute(this.getQuery()));
            connection.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
    }

    @Override
    public Stream<E> toStream() {
        DBConnection connection = new DBConnection();
        try {
            Stream stream = this.mapper.mapToStream(connection.execute(this.getQuery()));
            connection.close();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Stream.empty();
            }
        }
    }

    @Override
    public E[] toArray() {
        DBConnection connection = new DBConnection();
        try {
            BaseEntity[] baseEntityArray = (BaseEntity[])this.mapper.mapToArray(connection.execute(this.getQuery()));
            connection.close();
            return baseEntityArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return (BaseEntity[])Array.newInstance(this.type, 0);
            }
        }
    }

    @Override
    public <K, V> Map<K, V> toMap(Function<E, K> keyMapping, Function<E, V> valueMapping) {
        DBConnection connection = new DBConnection();
        try {
            Map<K, V> map = this.mapper.mapToMap(connection.execute(this.getQuery()), keyMapping, valueMapping);
            connection.close();
            return map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyMap();
            }
        }
    }

    @Override
    public Set<E> toSet() {
        DBConnection connection = new DBConnection();
        try {
            Set set = this.mapper.mapToSet(connection.execute(this.getQuery()));
            connection.close();
            return set;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptySet();
            }
        }
    }

    @Override
    protected String getQueryClauses(String tableName) {
        StringBuilder builder = new StringBuilder();
        this.buildWhereClause(builder, tableName);
        if (this.orderByClause != null && this.orderByClause.size() > 0) {
            builder.append(" order by ");
            if (this.orderByClause.size() == 1) {
                builder.append(Lambda2Sql.toSql(this.orderByClause.get(0), tableName));
            } else {
                StringJoiner joiner = new StringJoiner(", ", "coalesce(", ")");
                for (SqlFunction<E, ?> orderByFunction : this.orderByClause) {
                    joiner.add(Lambda2Sql.toSql(orderByFunction, tableName));
                }
                builder.append(joiner.toString());
            }
            builder.append(" ").append(this.orderType.getSql());
        }
        if (this.limit != null) {
            builder.append(" limit ").append(this.limitOffset).append(", ").append(this.limit);
        }
        return builder.toString();
    }
}

