/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.lambda2sql;

import com.trigersoft.jaque.expression.BinaryExpression;
import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionType;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.MemberExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.UnaryExpression;
import java.util.LinkedList;
import java.util.List;

public class ToSqlVisitor
implements ExpressionVisitor<StringBuilder> {
    private final String prefix;
    private StringBuilder sb;
    private Expression body;
    private List<ConstantExpression> parameters;

    ToSqlVisitor(String prefix) {
        this.prefix = prefix;
        this.sb = new StringBuilder();
        this.parameters = new LinkedList<ConstantExpression>();
    }

    private static String toSqlOp(int expressionType) {
        switch (expressionType) {
            case 10: {
                return "=";
            }
            case 2: {
                return "AND";
            }
            case 30: {
                return "OR";
            }
            case 8: {
                return "";
            }
        }
        return ExpressionType.toString((int)expressionType);
    }

    public StringBuilder visit(BinaryExpression e) {
        boolean quote;
        boolean bl = quote = e != this.body && e.getExpressionType() == 30;
        if (quote) {
            this.sb.append('(');
        }
        e.getFirst().accept((ExpressionVisitor)this);
        this.sb.append(' ').append(ToSqlVisitor.toSqlOp(e.getExpressionType())).append(' ');
        e.getSecond().accept((ExpressionVisitor)this);
        if (quote) {
            this.sb.append(')');
        }
        return this.sb;
    }

    public StringBuilder visit(ConstantExpression e) {
        if (e.getValue() instanceof String) {
            return this.sb.append("'").append(e.getValue().toString()).append("'");
        }
        return this.sb.append(e.getValue().toString());
    }

    public StringBuilder visit(InvocationExpression e) {
        e.getArguments().stream().filter(x -> x instanceof ConstantExpression && x.getResultType() != LambdaExpression.class).map(ConstantExpression.class::cast).forEach(this.parameters::add);
        return (StringBuilder)e.getTarget().accept((ExpressionVisitor)this);
    }

    public StringBuilder visit(LambdaExpression<?> e) {
        this.body = e.getBody();
        return (StringBuilder)this.body.accept((ExpressionVisitor)this);
    }

    public StringBuilder visit(MemberExpression e) {
        Object name = e.getMember().getName();
        name = ((String)name).replaceAll("^(get)", "");
        name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
        if (this.prefix == null) {
            return this.sb.append((String)name);
        }
        return this.sb.append(this.prefix).append(".").append((String)name);
    }

    public StringBuilder visit(ParameterExpression e) {
        this.parameters.get(e.getIndex()).accept((ExpressionVisitor)this);
        return this.sb;
    }

    public StringBuilder visit(UnaryExpression e) {
        this.sb.append(ToSqlVisitor.toSqlOp(e.getExpressionType()));
        return (StringBuilder)e.getFirst().accept((ExpressionVisitor)this);
    }
}

