/*
 * Decompiled with CFR 0.152.
 */
package com.github.continuousperftest.aspect.httpclient;

import com.github.continuousperftest.aspect.httpclient.HttpMethodExecuteAspect;
import com.github.continuousperftest.entity.domain.Header;
import com.github.continuousperftest.entity.domain.Perfomance;
import com.github.continuousperftest.entity.domain.RequestAttribute;
import com.github.continuousperftest.entity.domain.ResponseAttribute;
import com.github.continuousperftest.queue.impl.PerfomanceMetricQueue;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class ApacheHttpMethodExecuteAspect
extends HttpMethodExecuteAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ApacheHttpMethodExecuteAspect ajc$perSingletonInstance;

    @Pointcut(value="execution(* org.apache.http.impl.client.CloseableHttpClient.doExecute(..))")
    public /* synthetic */ void doExecute() {
    }

    @Around(value="doExecute()")
    public Object httpMethodExecution(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        HttpHost targetHost = (HttpHost)args[0];
        HttpRequest request = (HttpRequest)args[1];
        Instant start = Instant.now();
        CloseableHttpResponse response = (CloseableHttpResponse)joinPoint.proceed();
        Instant end = Instant.now();
        Duration between = Duration.between(start, end);
        long executionTime = between.toMillis();
        if (!ApacheHttpMethodExecuteAspect.ajc$inlineAccessFieldGet$com_github_continuousperftest_aspect_httpclient_ApacheHttpMethodExecuteAspect$com_github_continuousperftest_aspect_httpclient_HttpMethodExecuteAspect$IS_ENABLED()) {
            return response;
        }
        Perfomance prefomance = new Perfomance();
        prefomance.setRequestAttribute(this.toRequestAttribute(targetHost, request));
        prefomance.setResponseAttribute(this.toResponseAttribute(response));
        prefomance.setExecutionTimeInMillis((int)executionTime);
        PerfomanceMetricQueue.getInstance().offer(prefomance);
        return response;
    }

    private ResponseAttribute toResponseAttribute(CloseableHttpResponse response) {
        ResponseAttribute responseAttribute = new ResponseAttribute();
        responseAttribute.setStatusCode(response.getStatusLine().getStatusCode());
        responseAttribute.setReasonPhrase(response.getStatusLine().getReasonPhrase());
        responseAttribute.setProtocolVersion(response.getStatusLine().getProtocolVersion().toString());
        responseAttribute.setHeaders(this.toHeaders(response.getAllHeaders()));
        return responseAttribute;
    }

    private RequestAttribute toRequestAttribute(HttpHost targetHost, HttpRequest request) {
        RequestAttribute requestAttribute = new RequestAttribute();
        requestAttribute.setHostName(targetHost.getSchemeName());
        requestAttribute.setHostName(targetHost.getHostName());
        requestAttribute.setPort(targetHost.getPort());
        requestAttribute.setHttpMethod(request.getRequestLine().getMethod());
        requestAttribute.setUri(request.getRequestLine().getUri());
        requestAttribute.setHeaders(this.toHeaders(request.getAllHeaders()));
        return requestAttribute;
    }

    private List<Header> toHeaders(org.apache.http.Header[] headers) {
        return Arrays.stream(headers).map(header -> new Header(header.getName(), header.getValue())).collect(Collectors.toList());
    }

    public static ApacheHttpMethodExecuteAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.github.continuousperftest.aspect.httpclient.ApacheHttpMethodExecuteAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ApacheHttpMethodExecuteAspect.ajc$perSingletonInstance = new ApacheHttpMethodExecuteAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static /* synthetic */ boolean ajc$inlineAccessFieldGet$com_github_continuousperftest_aspect_httpclient_ApacheHttpMethodExecuteAspect$com_github_continuousperftest_aspect_httpclient_HttpMethodExecuteAspect$IS_ENABLED() {
        return HttpMethodExecuteAspect.IS_ENABLED;
    }
}

