/*
 * Decompiled with CFR 0.152.
 */
package com.github.continuousperftest.listener;

import com.github.continuousperftest.property.PropertyHolder;
import com.github.continuousperftest.queue.MetricQueue;
import com.github.continuousperftest.queue.impl.PerfomanceMetricQueue;
import com.github.continuousperftest.service.MetricExporter;
import com.github.continuousperftest.service.MetricExporterFactory;
import com.github.continuousperftest.service.MetricExporterService;
import com.github.continuousperftest.thread.PerfMetricConsumerTask;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.IExecutionListener;

public class TestNgExecutionListener
implements IExecutionListener {
    private static final int THREAD_NUMBER = 5;
    private static final MetricExporterService METRIC_EXPORTER_SERVICE = TestNgExecutionListener.getMetricExporterService();
    private static final MetricQueue METRIC_QUEUE = PerfomanceMetricQueue.getInstance();
    private static final ExecutorService THREAD_POOL_EXE = Executors.newFixedThreadPool(5);

    public void onExecutionStart() {
        String launchId = String.valueOf(UUID.randomUUID().toString()) + System.currentTimeMillis();
        String launchDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        System.setProperty("perf-test.launch.id", launchId);
        System.setProperty("perf-test.launch.date", launchDate);
        int i = 0;
        while (i <= 5) {
            THREAD_POOL_EXE.execute(new PerfMetricConsumerTask(METRIC_QUEUE, METRIC_EXPORTER_SERVICE));
            ++i;
        }
    }

    public void onExecutionFinish() {
        METRIC_EXPORTER_SERVICE.export(METRIC_QUEUE.pollAll());
    }

    private static MetricExporterService getMetricExporterService() {
        String exporterType = PropertyHolder.getPerfTestProperties().exporterType();
        return MetricExporterFactory.createExporter(MetricExporter.valueOf(exporterType.toUpperCase()));
    }
}

