/*
 * Decompiled with CFR 0.152.
 */
package com.github.continuousperftest.property;

import com.github.continuousperftest.property.JvmProperties;
import com.github.continuousperftest.property.PerfTestProperties;
import com.github.continuousperftest.property.TestNgProperties;
import java.util.HashMap;
import java.util.Map;
import org.aeonbits.owner.ConfigCache;

public class PropertyHolder {
    private static final Map<String, String> JVM_PROPS = new HashMap<Object, Object>(System.getProperties());
    private static final Map<String, String> REPORTING_PROPS = new HashMap<String, String>(PropertyHolder.findReportingProperties(JVM_PROPS));

    public static JvmProperties getJvmProperties() {
        return (JvmProperties)ConfigCache.getOrCreate(JvmProperties.class, (Map[])new Map[]{JVM_PROPS});
    }

    public static TestNgProperties getTestNgProperties() {
        return (TestNgProperties)ConfigCache.getOrCreate(TestNgProperties.class, (Map[])new Map[]{JVM_PROPS});
    }

    public static PerfTestProperties getPerfTestProperties() {
        return (PerfTestProperties)ConfigCache.getOrCreate(PerfTestProperties.class, (Map[])new Map[]{JVM_PROPS});
    }

    public static Map<String, String> getReportingProperties() {
        return REPORTING_PROPS;
    }

    private static Map<String, String> findReportingProperties(Map<String, String> jvmProps) {
        HashMap<String, String> reportingProperties = new HashMap<String, String>();
        String reportingArgsPattern = "perf-test.reporting.";
        for (Map.Entry<String, String> entry : jvmProps.entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.startsWith(reportingArgsPattern)) continue;
            key = key.replace(reportingArgsPattern, "");
            reportingProperties.put(key, entry.getValue());
        }
        return reportingProperties;
    }
}

