/*
 * Decompiled with CFR 0.152.
 */
package com.github.continuousperftest.queue.impl;

import com.github.continuousperftest.entity.domain.Perfomance;
import com.github.continuousperftest.queue.MetricQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PerfomanceMetricQueue
implements MetricQueue {
    private static final PerfomanceMetricQueue INSTANCE = new PerfomanceMetricQueue();
    private Queue<Perfomance> queue = new ConcurrentLinkedQueue<Perfomance>();
    private Lock lock = new ReentrantLock();

    private PerfomanceMetricQueue() {
    }

    public static PerfomanceMetricQueue getInstance() {
        return INSTANCE;
    }

    @Override
    public void offer(Perfomance metric) {
        this.queue.add(metric);
    }

    @Override
    public List<Perfomance> pollAll() {
        ArrayList<Perfomance> metrics = new ArrayList<Perfomance>();
        this.lock.lock();
        try {
            int queueSize = this.queue.size();
            int i = 0;
            while (i != queueSize) {
                metrics.add(this.queue.poll());
                ++i;
            }
        }
        finally {
            this.lock.unlock();
        }
        return metrics;
    }

    @Override
    public List<Perfomance> poll(int number) {
        ArrayList<Perfomance> metrics = new ArrayList<Perfomance>();
        this.lock.lock();
        try {
            if (this.queue.size() >= number) {
                int i = 0;
                while (i < number) {
                    metrics.add(this.queue.remove());
                    ++i;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return metrics;
    }
}

