/*
 * Decompiled with CFR 0.152.
 */
package com.github.continuousperftest.service;

import com.github.continuousperftest.service.MetricExporter;
import com.github.continuousperftest.service.MetricExporterService;
import com.github.continuousperftest.service.impl.LocalMetricExporterServiceImpl;
import com.github.continuousperftest.service.impl.RemoteMetricExporterServiceImpl;
import java.util.Iterator;
import java.util.ServiceLoader;

public class MetricExporterFactory {
    public static MetricExporterService createExporter(MetricExporter metricEporter) {
        switch (metricEporter) {
            case LOCAL: {
                return new LocalMetricExporterServiceImpl();
            }
            case REMOTE: {
                return new RemoteMetricExporterServiceImpl();
            }
            case OPTED: {
                MetricExporterService optedMetricExporter = MetricExporterFactory.loadMetricExporterServiceImpl();
                if (optedMetricExporter != null) {
                    return optedMetricExporter;
                }
                throw new RuntimeException("Specified implementation of MetricExporterService was not found!!!");
            }
        }
        return new LocalMetricExporterServiceImpl();
    }

    private static MetricExporterService loadMetricExporterServiceImpl() {
        MetricExporterService opted = null;
        ServiceLoader<MetricExporterService> loader = ServiceLoader.load(MetricExporterService.class);
        Iterator<MetricExporterService> metricExporters = loader.iterator();
        if (metricExporters.hasNext()) {
            opted = metricExporters.next();
        }
        return opted;
    }
}

