/*
 * Decompiled with CFR 0.152.
 */
package com.github.continuousperftest.service.impl;

import com.github.continuousperftest.entity.domain.Environment;
import com.github.continuousperftest.entity.domain.Perfomance;
import com.github.continuousperftest.entity.dto.PerfomanceMetric;
import com.github.continuousperftest.property.JvmProperties;
import com.github.continuousperftest.property.PerfTestProperties;
import com.github.continuousperftest.property.PropertyHolder;
import com.github.continuousperftest.property.TestNgProperties;
import com.github.continuousperftest.service.MetricExporterService;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class LocalMetricExporterServiceImpl
implements MetricExporterService {
    @Override
    public void export(List<Perfomance> metrics) {
        PerfTestProperties perfTestProps = PropertyHolder.getPerfTestProperties();
        JvmProperties jvmProps = PropertyHolder.getJvmProperties();
        Environment env = new Environment();
        env.setLaunchId(perfTestProps.launchId());
        env.setLaunchDate(perfTestProps.launchDate());
        env.setExecutionArgs(this.getExecutionArgs());
        CopyOnWriteArrayList perfMetrics = new CopyOnWriteArrayList();
        metrics.forEach(metric -> {
            boolean bl = perfMetrics.add(new PerfomanceMetric(env, (Perfomance)metric));
        });
        Gson gson = new Gson();
        for (PerfomanceMetric perfMetric : perfMetrics) {
            String resultFileName = String.format("%s-result.json", UUID.randomUUID().toString());
            Path resultDir = Paths.get(jvmProps.projectDirectory(), perfTestProps.resultsDirectory());
            try {
                Path createdResultDir = Files.createDirectories(resultDir, new FileAttribute[0]);
                Path resultFile = createdResultDir.resolve(resultFileName);
                Files.write(resultFile, gson.toJson((Object)perfMetric).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, String> getExecutionArgs() {
        HashMap<String, String> executionArgs = new HashMap<String, String>();
        executionArgs.putAll(PropertyHolder.getReportingProperties());
        TestNgProperties testNgProps = PropertyHolder.getTestNgProperties();
        executionArgs.put("parallel", testNgProps.parallelMode());
        executionArgs.put("groups", testNgProps.groups());
        executionArgs.put("threadcount", String.valueOf(testNgProps.threadCount()));
        executionArgs.put("dataproviderthreadcount", String.valueOf(testNgProps.dataProviderThreadCount()));
        return executionArgs;
    }
}

