/*
 * Decompiled with CFR 0.152.
 */
package com.github.continuousperftest.service.impl;

import com.github.continuousperftest.entity.domain.Environment;
import com.github.continuousperftest.entity.domain.Perfomance;
import com.github.continuousperftest.entity.dto.PerfomanceMetric;
import com.github.continuousperftest.property.PerfTestProperties;
import com.github.continuousperftest.property.PropertyHolder;
import com.github.continuousperftest.property.TestNgProperties;
import com.github.continuousperftest.service.MetricExporterService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RemoteMetricExporterServiceImpl
implements MetricExporterService {
    @Override
    public void export(List<Perfomance> metrics) {
        PerfTestProperties perfTestProps = PropertyHolder.getPerfTestProperties();
        Environment env = new Environment();
        env.setLaunchId(perfTestProps.launchId());
        env.setLaunchDate(perfTestProps.launchDate());
        env.setExecutionArgs(this.getExecutionArgs());
        CopyOnWriteArrayList perfMetrics = new CopyOnWriteArrayList();
        metrics.forEach(metric -> {
            boolean bl = perfMetrics.add(new PerfomanceMetric(env, (Perfomance)metric));
        });
        RestTemplate restTemplate = new RestTemplate(Arrays.asList(new GsonHttpMessageConverter()));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(perfMetrics, (MultiValueMap)headers);
        String url = String.valueOf(perfTestProps.resultsHost()) + "/api/v1/metrics";
        restTemplate.exchange(url, HttpMethod.POST, entity, Void.class, new Object[0]);
    }

    private Map<String, String> getExecutionArgs() {
        HashMap<String, String> executionArgs = new HashMap<String, String>();
        executionArgs.putAll(PropertyHolder.getReportingProperties());
        TestNgProperties testNgProps = PropertyHolder.getTestNgProperties();
        executionArgs.put("parallel", testNgProps.parallelMode());
        executionArgs.put("groups", this.getOrderedGroupsSplittedByComma(testNgProps.groups()));
        executionArgs.put("threadcount", String.valueOf(testNgProps.threadCount()));
        executionArgs.put("dataproviderthreadcount", String.valueOf(testNgProps.dataProviderThreadCount()));
        return executionArgs;
    }

    private String getOrderedGroupsSplittedByComma(String groups) {
        if (groups.trim().contains(",")) {
            List<String> groupsSplittedByComma = Arrays.asList(groups.split(","));
            groupsSplittedByComma.sort((group1, group2) -> group1.compareTo((String)group2));
            return String.join((CharSequence)",", groupsSplittedByComma);
        }
        return groups;
    }
}

