/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.fileimport.base;

import com.github.cosycode.ext.fileimport.base.FieldMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class RecordMapping {
    private Map<String, FieldMapping<?>> headerFieldMappingMap;
    private Map<Integer, String> positionMapping;

    public void addFieldMapping(@NonNull String headerName, @NonNull FieldMapping<?> fieldMapping) {
        if (headerName == null) {
            throw new NullPointerException("headerName is marked non-null but is null");
        }
        if (fieldMapping == null) {
            throw new NullPointerException("fieldMapping is marked non-null but is null");
        }
        if (this.headerFieldMappingMap == null) {
            this.headerFieldMappingMap = new HashMap();
        }
        this.headerFieldMappingMap.put(headerName, fieldMapping);
    }

    public FieldMapping<?> getFieldMappingByHeadName(@NonNull String headName) {
        if (headName == null) {
            throw new NullPointerException("headName is marked non-null but is null");
        }
        return this.headerFieldMappingMap.get(headName);
    }

    public FieldMapping<?> getFieldMappingByCellNum(int cellNum) {
        String headName = this.positionMapping.get(cellNum);
        return this.headerFieldMappingMap.get(headName);
    }

    public void putPositionMapping(int cellNum, String headName) {
        if (this.positionMapping == null) {
            this.positionMapping = new HashMap<Integer, String>();
        }
        this.positionMapping.put(cellNum, headName);
    }

    public List<String> getNotFoundHeaderName() {
        return this.headerFieldMappingMap.entrySet().stream().filter(entry -> ((FieldMapping)entry.getValue()).isRequire() && !this.positionMapping.containsValue(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

