/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.fileimport.excel;

import com.github.cosycode.ext.fileimport.base.FieldMapping;
import com.github.cosycode.ext.fileimport.base.RecordMapping;
import com.github.cosycode.ext.fileimport.excel.AbstractSheetBeanMappingAdapter;
import com.github.cosycode.ext.fileimport.excel.ParsedSheetHandler;
import com.github.cosycode.ext.fileimport.excel.SheetInfo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelResolver {
    private static final Logger log = LoggerFactory.getLogger(ExcelResolver.class);

    public static Workbook getMatchWorkbook(@NonNull ExcelType excelType, InputStream in) throws IOException {
        if (excelType == null) {
            throw new NullPointerException("excelType is marked non-null but is null");
        }
        if (excelType == ExcelType.XLS) {
            return new HSSFWorkbook(in);
        }
        if (excelType == ExcelType.XLSX) {
            return new XSSFWorkbook(in);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }

    public static List<ParsedSheetHandler<?>> resolveRecord(@NonNull InputStream is, @NonNull ExcelType excelType, @NonNull Set<Class<? extends AbstractSheetBeanMappingAdapter<?>>> adapterClassSet) throws IOException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        if (excelType == null) {
            throw new NullPointerException("excelType is marked non-null but is null");
        }
        if (adapterClassSet == null) {
            throw new NullPointerException("adapterClassSet is marked non-null but is null");
        }
        List<AbstractSheetBeanMappingAdapter<?>> adapters = adapterClassSet.stream().map(it -> {
            AbstractSheetBeanMappingAdapter abstractSheetBeanMappingAdapter = null;
            try {
                abstractSheetBeanMappingAdapter = (AbstractSheetBeanMappingAdapter)it.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error("new Instance error", (Throwable)e);
            }
            return abstractSheetBeanMappingAdapter;
        }).collect(Collectors.toList());
        return ExcelResolver.resolveRecord(is, excelType, adapters);
    }

    public static List<ParsedSheetHandler<?>> resolveRecord(@NonNull InputStream is, @NonNull ExcelType excelType, List<AbstractSheetBeanMappingAdapter<?>> adapters) throws IOException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        if (excelType == null) {
            throw new NullPointerException("excelType is marked non-null but is null");
        }
        ArrayList resultList = new ArrayList();
        try (Workbook workbook = ExcelResolver.getMatchWorkbook(excelType, is);){
            int len = workbook.getNumberOfSheets();
            for (int index = 0; index < len; ++index) {
                Sheet sheet = workbook.getSheetAt(index);
                if (sheet == null) continue;
                String sheetName = sheet.getSheetName();
                List collect = adapters.stream().filter(it -> it.isMatchSheetName(sheetName)).collect(Collectors.toList());
                if (collect.isEmpty()) continue;
                if (collect.size() > 1) {
                    throw new RuntimeException("\u51fd\u6570\u8c03\u7528\u9519\u8bef, AbstractSheetBeanMappingAdapter \u51b2\u7a81, resolveQuoteExcel \u89e3\u6790\u65f6\u53d1\u73b0\u5339\u914d\u7684 SheetBeanMapping \u6709\u591a\u4e2a");
                }
                AbstractSheetBeanMappingAdapter relateAdapter = (AbstractSheetBeanMappingAdapter)collect.get(0);
                SheetInfo sheetInfo = new SheetInfo();
                sheetInfo.setSheetName(sheetName);
                log.info("resolveQuoteExcel start!!! -> sheetName : {}", (Object)sheetName);
                RecordMapping recordMapping = relateAdapter.getSheetBeanMapping();
                List<Map<String, Object>> maps = ExcelResolver.analyzeSheet(sheet, recordMapping);
                ParsedSheetHandler parsedSheetHandler = relateAdapter.disposeParsedSheet(sheetInfo, maps);
                resultList.add(parsedSheetHandler);
            }
        }
        return resultList;
    }

    private static List<Map<String, Object>> analyzeSheet(Sheet sheet, @NonNull RecordMapping sheetBeanMappingRule) {
        int lastRowNum;
        if (sheetBeanMappingRule == null) {
            throw new NullPointerException("sheetBeanMappingRule is marked non-null but is null");
        }
        if (sheet == null) {
            return new ArrayList<Map<String, Object>>();
        }
        int firstRowNum = sheet.getFirstRowNum();
        if (firstRowNum == (lastRowNum = sheet.getLastRowNum())) {
            return new ArrayList<Map<String, Object>>();
        }
        String sheetName = sheet.getSheetName();
        Row firstRow = sheet.getRow(firstRowNum);
        int firstCellNum = firstRow.getFirstCellNum();
        short lastCellNum = firstRow.getLastCellNum();
        log.info("sheetName : {}, (topRowNum, lastRowNum)=>({}, {})", new Object[]{sheetName, firstRowNum, lastRowNum});
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        for (int i = firstCellNum; i < lastCellNum; ++i) {
            Cell cell = firstRow.getCell(i);
            String stringCellValue = cell.getStringCellValue();
            if (!StringUtils.isNotBlank((CharSequence)stringCellValue)) continue;
            columnIndexList.add(cell.getColumnIndex());
            sheetBeanMappingRule.putPositionMapping(cell.getColumnIndex(), stringCellValue);
        }
        List<String> notFoundHeaderName = sheetBeanMappingRule.getNotFoundHeaderName();
        if (!notFoundHeaderName.isEmpty()) {
            String temp = "excel\u4e2d\u672a\u53d1\u73b0\u5fc5\u8981\u7684\u5217, \u8bf7\u68c0\u67e5\u6a21\u677f, <br> => \u8868\u540d : %s<br> => \u5217 : [%s]";
            String msg = String.format("excel\u4e2d\u672a\u53d1\u73b0\u5fc5\u8981\u7684\u5217, \u8bf7\u68c0\u67e5\u6a21\u677f, <br> => \u8868\u540d : %s<br> => \u5217 : [%s]", sheetName, StringUtils.join(notFoundHeaderName, (String)", "));
            log.warn(msg);
            throw new RuntimeException(msg);
        }
        ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
        for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; ++rowNum) {
            Row sheetRow = sheet.getRow(rowNum);
            Map<String, Object> record = ExcelResolver.analyzeRow(sheetBeanMappingRule, sheetName, columnIndexList, sheetRow);
            records.add(record);
        }
        return records;
    }

    private static Map<String, Object> analyzeRow(@NonNull RecordMapping sheetBeanMappingRule, String sheetName, List<Integer> columnIndexList, Row sheetRow) {
        if (sheetBeanMappingRule == null) {
            throw new NullPointerException("sheetBeanMappingRule is marked non-null but is null");
        }
        HashMap<String, Object> record = new HashMap<String, Object>();
        columnIndexList.forEach(colIndex -> {
            if (sheetRow.getPhysicalNumberOfCells() == 0) {
                return;
            }
            Cell cell = sheetRow.getCell(colIndex.intValue());
            FieldMapping<?> fieldMapping = sheetBeanMappingRule.getFieldMappingByCellNum((int)colIndex);
            if (fieldMapping == null) {
                return;
            }
            try {
                Object obj = null;
                if (cell != null) {
                    obj = ExcelResolver.resolveCell(cell, fieldMapping.getType());
                    obj = fieldMapping.resolveValue(obj);
                }
                if (obj != null) {
                    record.put(fieldMapping.getFieldName(), obj);
                    return;
                }
                if (fieldMapping.getDefaultObj() != null) {
                    record.put(fieldMapping.getFieldName(), fieldMapping.getDefaultObj());
                    return;
                }
                if (fieldMapping.isRequire()) {
                    throw new ParseException("\u4e0d\u80fd\u4e3a\u7a7a", 0);
                }
            }
            catch (RuntimeException | ParseException e) {
                CellAddress cellAddress = new CellAddress(sheetRow.getRowNum(), colIndex.intValue());
                String msg = String.format("\u89e3\u6790\u5355\u5143\u683c\u9519\u8bef<br>=> \u8868\u540d : %s<br>=> \u4f4d\u7f6e : %s<br>=> \u503c : %s<br>=> error : %s", sheetName, cellAddress, cell, e.getMessage());
                String desc = String.format("regex : %s", fieldMapping.getRuleRegex());
                throw new RuntimeException(msg + desc);
            }
        });
        return record;
    }

    public static Object resolveCell(Cell cell, Class<?> tClass) throws ParseException {
        if (cell == null) {
            return null;
        }
        CellType cellTypeEnum = cell.getCellTypeEnum();
        switch (cellTypeEnum) {
            case NUMERIC: {
                double numericCellValue = cell.getNumericCellValue();
                if (tClass.equals(String.class)) {
                    return String.valueOf(numericCellValue);
                }
                if (tClass.equals(Integer.class) || tClass.equals(Integer.TYPE)) {
                    return (int)numericCellValue;
                }
                if (tClass.equals(Date.class)) {
                    return cell.getDateCellValue();
                }
                if (tClass.equals(BigDecimal.class)) {
                    return BigDecimal.valueOf(numericCellValue);
                }
                if (!tClass.equals(Double.class) && !tClass.equals(Double.TYPE)) break;
                return numericCellValue;
            }
            case STRING: {
                String stringCellValue = cell.getStringCellValue();
                if (tClass.equals(String.class)) {
                    return stringCellValue;
                }
                if (tClass.equals(Boolean.class) || tClass.equals(Boolean.TYPE)) {
                    return Boolean.parseBoolean(stringCellValue);
                }
                if (tClass.equals(Integer.TYPE) || tClass.equals(Integer.class)) {
                    return Integer.parseInt(stringCellValue);
                }
                if (tClass.equals(Date.class)) {
                    return DateUtils.parseDate((String)stringCellValue, (String[])new String[0]);
                }
                if (!tClass.equals(BigDecimal.class)) break;
                return new BigDecimal(stringCellValue);
            }
            case BOOLEAN: {
                boolean booleanCellValue = cell.getBooleanCellValue();
                if (tClass.equals(String.class)) {
                    return Boolean.toString(booleanCellValue);
                }
                if (!tClass.equals(Boolean.TYPE) && !tClass.equals(Boolean.class)) break;
                return booleanCellValue;
            }
            case FORMULA: {
                return cell.getRichStringCellValue().getString();
            }
            case ERROR: {
                return cell.getErrorCellValue();
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public static enum ExcelType {
        XLS,
        XLSX;


        public static ExcelType getByJudgeSuffix(String fileName) {
            if (fileName.endsWith(".xls")) {
                return XLS;
            }
            if (fileName.endsWith(".xlsx")) {
                return XLSX;
            }
            return null;
        }
    }
}

