/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.hub;

import com.github.cosycode.ext.hub.AbstractClosureProxy;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import lombok.NonNull;

public class OnceExecClosureProxy<T, P, R>
extends AbstractClosureProxy<T, P, R> {
    private final Lock lock = new ReentrantLock();
    private T skip;

    public OnceExecClosureProxy(@NonNull T then) {
        super(then);
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
    }

    public OnceExecClosureProxy(@NonNull T then, @NonNull BiFunction<T, P, R> function) {
        super(then, function);
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
    }

    public OnceExecClosureProxy(@NonNull T then, @NonNull BiConsumer<T, P> biConsumer) {
        super(then, biConsumer);
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        if (biConsumer == null) {
            throw new NullPointerException("biConsumer is marked non-null but is null");
        }
    }

    public static <T> T of(T then) {
        return new OnceExecClosureProxy(then).proxy();
    }

    public OnceExecClosureProxy<T, P, R> skip(T skip) {
        this.skip = skip;
        return this;
    }

    @Override
    public R closureFunction(P params) {
        block6: {
            if (this.lock.tryLock()) {
                try {
                    if (this.functional != null) {
                        Object r = this.biFunction.apply(this.functional, params);
                        return r;
                    }
                    break block6;
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.skip != null) {
                return this.biFunction.apply(this.skip, params);
            }
        }
        return null;
    }
}

