/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.hub;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;

public class OnceExecutes {
    public static <T> Consumer<T> consumer(@NonNull Consumer<T> then) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        OnceExecutorForConsumer<T> onceExecutor = new OnceExecutorForConsumer<T>(then);
        return onceExecutor::onceExe;
    }

    public static <T> Consumer<T> consumer(@NonNull Consumer<T> then, Consumer<T> skip) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        OnceExecutorForConsumer<T> onceExecutor = new OnceExecutorForConsumer<T>(then);
        onceExecutor.setSkip(skip);
        return onceExecutor::onceExe;
    }

    public static Runnable runnable(@NonNull Runnable then) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        OnceExecutorForRunnable onceExecutor = new OnceExecutorForRunnable(then);
        return onceExecutor::onceExe;
    }

    public static Runnable runnable(@NonNull Runnable then, Runnable skip) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        OnceExecutorForRunnable onceExecutor = new OnceExecutorForRunnable(then);
        onceExecutor.setSkip(skip);
        return onceExecutor::onceExe;
    }

    public static <T, R> Function<T, R> function(@NonNull Function<T, R> then) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        OnceExecutorForFunction<T, R> onceExecutor = new OnceExecutorForFunction<T, R>(then);
        return onceExecutor::onceExe;
    }

    public static <T, R> Function<T, R> function(@NonNull Function<T, R> then, Function<T, R> skip) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        OnceExecutorForFunction<T, R> onceExecutor = new OnceExecutorForFunction<T, R>(then);
        onceExecutor.setSkip(skip);
        return onceExecutor::onceExe;
    }

    public static <R> Supplier<R> supplier(@NonNull Supplier<R> then) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        OnceExecutorForSupplier<R> onceExecutor = new OnceExecutorForSupplier<R>(then);
        return onceExecutor::onceExe;
    }

    public static <R> Supplier<R> supplier(@NonNull Supplier<R> then, Supplier<R> skip) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        OnceExecutorForSupplier<R> onceExecutor = new OnceExecutorForSupplier<R>(then);
        onceExecutor.setSkip(skip);
        return onceExecutor::onceExe;
    }

    public static <T, P, R> Function<P, R> exec(@NonNull T then, @NonNull BiFunction<T, P, R> function) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        OnceExecutorForCommon<Object, P, R> onceExecutor = new OnceExecutorForCommon<Object, P, R>(then, null, function);
        return onceExecutor::onceExe;
    }

    public static <T, P, R> Function<P, R> exec(@NonNull T then, T skip, @NonNull BiFunction<T, P, R> function) {
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        OnceExecutorForCommon<T, P, R> onceExecutor = new OnceExecutorForCommon<T, P, R>(then, skip, function);
        return onceExecutor::onceExe;
    }

    private OnceExecutes() {
    }

    public static class OnceExecutorForFunction<T, R> {
        private final Lock lock = new ReentrantLock();
        private final Function<T, R> then;
        private Function<T, R> skip;

        public OnceExecutorForFunction(Function<T, R> then) {
            this.then = then;
        }

        public R onceExe(T e) {
            if (this.lock.tryLock()) {
                try {
                    R r = this.then.apply(e);
                    return r;
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.skip != null) {
                return this.skip.apply(e);
            }
            return null;
        }

        public void setSkip(Function<T, R> skip) {
            this.skip = skip;
        }
    }

    public static class OnceExecutorForSupplier<T> {
        private final Lock lock = new ReentrantLock();
        private final Supplier<T> then;
        private Supplier<T> skip;

        public OnceExecutorForSupplier(Supplier<T> then) {
            this.then = then;
        }

        public T onceExe() {
            if (this.lock.tryLock()) {
                try {
                    T t = this.then.get();
                    return t;
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.skip != null) {
                return this.skip.get();
            }
            return null;
        }

        public void setSkip(Supplier<T> skip) {
            this.skip = skip;
        }
    }

    public static class OnceExecutorForConsumer<T> {
        private final Lock lock = new ReentrantLock();
        private final Consumer<T> then;
        private Consumer<T> skip;

        public OnceExecutorForConsumer(Consumer<T> then) {
            this.then = then;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onceExe(T e) {
            if (this.lock.tryLock()) {
                try {
                    if (this.then == null) return;
                    this.then.accept(e);
                    return;
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                if (this.skip == null) return;
                this.skip.accept(e);
            }
        }

        public void setSkip(Consumer<T> skip) {
            this.skip = skip;
        }
    }

    public static class OnceExecutorForRunnable {
        private final Lock lock = new ReentrantLock();
        private final Runnable then;
        private Runnable skip;

        public OnceExecutorForRunnable(Runnable then) {
            this.then = then;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onceExe() {
            if (this.lock.tryLock()) {
                try {
                    if (this.then == null) return;
                    this.then.run();
                    return;
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                if (this.skip == null) return;
                this.skip.run();
            }
        }

        public void setSkip(Runnable skip) {
            this.skip = skip;
        }
    }

    public static class OnceExecutorForCommon<T, P, R> {
        private final Lock lock = new ReentrantLock();
        private final T then;
        private final BiFunction<T, P, R> biFunction;
        private T skip;

        public OnceExecutorForCommon(T then, BiFunction<T, P, R> function) {
            this.then = then;
            this.biFunction = function;
        }

        public OnceExecutorForCommon(T then, T skip, BiFunction<T, P, R> function) {
            this.then = then;
            this.skip = skip;
            this.biFunction = function;
        }

        public R onceExe(P params) {
            block6: {
                if (this.lock.tryLock()) {
                    try {
                        if (this.then != null) {
                            R r = this.biFunction.apply(this.then, params);
                            return r;
                        }
                        break block6;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                if (this.skip != null) {
                    return this.biFunction.apply(this.skip, params);
                }
            }
            return null;
        }

        public void setSkip(T skip) {
            this.skip = skip;
        }
    }
}

