/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.se.robot;

import com.github.cosycode.common.base.RunnableWithThrow;
import com.github.cosycode.common.ext.hub.SimpleCode;
import com.github.cosycode.common.thread.AsynchronousProcessor;
import com.github.cosycode.ext.se.robot.KeyPressUtils;
import java.awt.Robot;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyPressDecorator {
    private static final Logger log = LoggerFactory.getLogger(KeyPressDecorator.class);
    private final CharsetEncoder charsetEncoder = Charset.forName("GBK").newEncoder();
    private final AsynchronousProcessor<Character> asynchronousProcessor;
    private Robot robot;

    public KeyPressDecorator(Robot robot) {
        Consumer<Character> characterPredicate = ch -> SimpleCode.ignoreException((RunnableWithThrow & Serializable)() -> KeyPressUtils.keyPressWithString(this.robot, ch.charValue(), this.charsetEncoder, -1));
        this.asynchronousProcessor = AsynchronousProcessor.ofConsumer(characterPredicate).setName("KeyPressDecorator-Default");
        this.asynchronousProcessor.start();
        this.robot = robot;
    }

    public void print(String s) {
        for (char aChar : s.toCharArray()) {
            this.asynchronousProcessor.add((Object)Character.valueOf(aChar));
        }
    }

    public void print(char key) {
        this.asynchronousProcessor.add((Object)Character.valueOf(key));
    }

    public AsynchronousProcessor<Character> getAsynchronousProcessor() {
        return this.asynchronousProcessor;
    }

    public Robot getRobot() {
        return this.robot;
    }
}

