/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.swing;

import java.awt.Component;
import java.awt.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingUtils {
    private static final Logger log = LoggerFactory.getLogger(SwingUtils.class);
    public static final int INTERVAL = 5;
    public static final int BASE_TIME = 1000;
    public static final int PX_ONE_TIME = 1;

    public static void moveComp(Component component, Point toPoint) throws InterruptedException {
        SwingUtils.moveComp(component, toPoint, 1000, 5, 1);
    }

    public static void moveComp(Component component, Point toPoint, int baseTime, int interval, int pxOneTime) throws InterruptedException {
        Point fromPoint = component.getLocation();
        int xSub = toPoint.x - fromPoint.x;
        int ySub = toPoint.y - fromPoint.y;
        double sqrt = Math.sqrt(Math.sqrt(Math.pow(xSub, 2.0) + Math.pow(ySub, 2.0)) / (double)pxOneTime * (double)interval / (double)baseTime);
        int times = (int)((double)baseTime * sqrt / (double)interval);
        SwingUtils.moveComp(component, toPoint, times, interval);
    }

    public static void moveComp(Component component, Point toPoint, int times, int interval) throws InterruptedException {
        Point fromPoint = component.getLocation();
        int xSub = toPoint.x - fromPoint.x;
        int ySub = toPoint.y - fromPoint.y;
        for (int i = 0; i < times; ++i) {
            double p = (double)i / (double)times;
            component.setLocation((int)((double)fromPoint.x + (double)xSub * p), (int)((double)fromPoint.y + (double)ySub * p));
            Thread.sleep(interval);
        }
        component.setLocation(toPoint.x, toPoint.y);
    }

    private SwingUtils() {
    }
}

