/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.swing.comp;

import java.awt.Color;
import java.io.Serializable;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="JTextAreaAppender", category="Core", elementType="appender", printObject=true)
public class JTextAreaAppender
extends AbstractAppender {
    protected static JTextPane defaultJTextPane;
    protected final JTextPane jTextPane;

    protected JTextAreaAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, JTextPane jTextPane) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        this.jTextPane = jTextPane;
        Style def = jTextPane.getStyledDocument().addStyle(null, null);
        StyleConstants.setFontFamily(def, "verdana");
        StyleConstants.setFontSize(def, 12);
        Style info = jTextPane.addStyle(Level.INFO.name(), def);
        StyleConstants.setForeground(info, Color.black);
        jTextPane.setParagraphAttributes(info, true);
        Style debug = jTextPane.addStyle(Level.DEBUG.name(), def);
        StyleConstants.setForeground(debug, Color.GRAY);
        jTextPane.setParagraphAttributes(debug, true);
        Style error = jTextPane.addStyle(Level.ERROR.name(), def);
        StyleConstants.setForeground(error, Color.RED);
        jTextPane.setParagraphAttributes(error, true);
        Style warn = jTextPane.addStyle(Level.WARN.name(), def);
        StyleConstants.setForeground(warn, Color.YELLOW);
        jTextPane.setParagraphAttributes(warn, true);
    }

    @PluginFactory
    public static JTextAreaAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions) {
        if (name == null) {
            LOGGER.error("No name provided for MyCustomAppenderImpl");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (defaultJTextPane == null) {
            throw new RuntimeException("\u4e8b\u5148\u8bf7\u914d\u7f6e\u597d defaultJTextPane");
        }
        return new JTextAreaAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, defaultJTextPane);
    }

    public void append(LogEvent event) {
        block2: {
            try {
                byte[] bytes = this.getLayout().toByteArray(event);
                Level level = event.getLevel();
                Style style = this.jTextPane.getStyle(level.name());
                Document document = this.jTextPane.getDocument();
                document.insertString(document.getLength(), new String(bytes), style);
            }
            catch (Exception ex) {
                if (this.ignoreExceptions()) break block2;
                throw new AppenderLoggingException((Throwable)ex);
            }
        }
    }

    public static void setDefaultJTextPane(JTextPane defaultJTextPane) {
        JTextAreaAppender.defaultJTextPane = defaultJTextPane;
    }

    public JTextPane getJTextPane() {
        return this.jTextPane;
    }
}

