/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.hub;

import com.github.cosycode.ext.hub.AbstractClosureProxy;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import lombok.NonNull;

public class SingletonClosureProxy<T, P, R>
extends AbstractClosureProxy<T, P, R> {
    private volatile R obj;

    public SingletonClosureProxy(@NonNull T then) {
        super(then);
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
    }

    public SingletonClosureProxy(@NonNull T then, @NonNull BiFunction<T, P, R> function) {
        super(then, function);
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
    }

    public SingletonClosureProxy(@NonNull T then, @NonNull BiConsumer<T, P> biConsumer) {
        super(then, biConsumer);
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        if (biConsumer == null) {
            throw new NullPointerException("biConsumer is marked non-null but is null");
        }
    }

    public static <R> Supplier<R> of(Supplier<R> supplier) {
        return (Supplier)new SingletonClosureProxy(supplier).proxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R closureFunction(P params) {
        if (this.obj == null) {
            SingletonClosureProxy singletonClosureProxy = this;
            synchronized (singletonClosureProxy) {
                if (this.obj == null) {
                    Object apply = this.biFunction.apply(this.functional, params);
                    this.obj = apply;
                    return apply;
                }
            }
        }
        return this.obj;
    }
}

