/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.io.cache;

import com.github.cosycode.common.base.RunnableWithThrow;
import com.github.cosycode.common.base.SupplierWithThrow;
import com.github.cosycode.common.ext.hub.Throws;
import com.github.cosycode.common.util.io.FileSystemUtils;
import com.github.cosycode.common.util.io.IoUtils;
import com.github.cosycode.ext.io.cache.ICacheStack;
import com.github.cosycode.ext.se.util.JsonUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;

public abstract class AbstractObjCacheHandler<T extends ICacheStack> {
    private String tag;

    public abstract void put(T var1);

    public abstract T get();

    public boolean validate(T t) {
        return t.validate();
    }

    public void clear() {
        this.put(null);
    }

    public static <T extends ICacheStack> AbstractObjCacheHandler<T> geneMemoryCacheHandler(String tag) {
        return new AbstractObjCacheHandler<T>(tag){
            T value;

            @Override
            public void put(T value) {
                this.value = value;
            }

            @Override
            public T get() {
                return this.value;
            }
        };
    }

    public static <T extends ICacheStack> AbstractObjCacheHandler<T> geneFileCacheHandler(String tag, final @NonNull String filePath, final Class<T> tClass) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return new AbstractObjCacheHandler<T>(tag + " => " + filePath){

            @Override
            public void put(T value) {
                File file = new File(filePath);
                FileSystemUtils.insureFileExist((File)file);
                Throws.runtimeEpt((RunnableWithThrow & Serializable)() -> IoUtils.writeFile((String)file.getPath(), (byte[])JsonUtils.toJson(value).getBytes(StandardCharsets.UTF_8)));
            }

            @Override
            public T get() {
                File file = new File(filePath);
                if (file.exists()) {
                    String response = (String)Throws.runtimeEpt((SupplierWithThrow & Serializable)() -> IoUtils.readFile((File)file));
                    return (ICacheStack)JsonUtils.fromJson(response, tClass);
                }
                return null;
            }

            @Override
            public void clear() {
                File file = new File(filePath);
                file.deleteOnExit();
            }
        };
    }

    public AbstractObjCacheHandler(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }
}

