/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.io.cache;

import com.github.cosycode.common.lang.BaseRuntimeException;
import com.github.cosycode.ext.io.cache.AbstractObjCacheHandler;
import com.github.cosycode.ext.io.cache.ICacheStack;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjCacheChain<T extends ICacheStack> {
    private static final Logger log = LoggerFactory.getLogger(ObjCacheChain.class);
    final List<AbstractObjCacheHandler<T>> cacheHandlerList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getData() {
        Objects.requireNonNull(this.cacheHandlerList);
        if (this.cacheHandlerList.isEmpty()) {
            throw new BaseRuntimeException("cacheHandlerList is empty", new Object[0]);
        }
        AbstractObjCacheHandler<T> firstHandler = this.cacheHandlerList.get(0);
        T t = firstHandler.get();
        if (t == null || !firstHandler.validate(t)) {
            List<AbstractObjCacheHandler<T>> list = this.cacheHandlerList;
            synchronized (list) {
                t = firstHandler.get();
                if (t == null || !firstHandler.validate(t)) {
                    Iterator<AbstractObjCacheHandler<T>> iterator = this.cacheHandlerList.iterator();
                    return this.getData(iterator);
                }
            }
        }
        return t;
    }

    private T getData(@NonNull Iterator<AbstractObjCacheHandler<T>> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (!iterator.hasNext()) {
            throw new BaseRuntimeException("cacheHandlerList \u91cc\u9762\u5df2\u7ecf\u7a7a\u4e86, \u8bf7\u786e\u4fdd\u6700\u540e\u4e00\u4e2a AbstractCacheHandler<T> \u5b9e\u4f8b\u5bf9\u8c61\u53ef\u4ee5\u6b63\u786e\u83b7\u53d6\u5230\u5143\u7d20", new Object[0]);
        }
        AbstractObjCacheHandler<T> item = iterator.next();
        T pop = item.get();
        if (pop != null) {
            boolean validate = item.validate(pop);
            if (validate) {
                return pop;
            }
            log.debug("{}[{}] \u4e2d\u83b7\u53d6\u5230\u7684\u5143\u7d20\u9a8c\u8bc1\u5931\u8d25, \u6e05\u9664\u5931\u6548\u5143\u7d20", item.getClass(), (Object)item.getTag());
            item.clear();
        }
        pop = this.getData(iterator);
        Objects.requireNonNull(pop);
        log.debug("\u83b7\u53d6\u5230\u6709\u6548\u5143\u7d20, \u5c06\u6709\u6548\u5143\u7d20\u7f13\u5b58\u8fdb {}[{}]", item.getClass(), (Object)item.getTag());
        item.put(pop);
        return pop;
    }

    public ObjCacheChain(List<AbstractObjCacheHandler<T>> cacheHandlerList) {
        this.cacheHandlerList = cacheHandlerList;
    }
}

