/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.se.json;

import com.github.cosycode.common.ext.bean.DoubleBean;
import com.github.cosycode.common.lang.BaseRuntimeException;
import com.github.cosycode.common.lang.NotSupportException;
import com.github.cosycode.common.lang.ShouldNotHappenException;
import com.github.cosycode.common.util.common.CollectUtils;
import com.github.cosycode.ext.se.json.JsonArr;
import com.github.cosycode.ext.se.json.JsonNul;
import com.github.cosycode.ext.se.json.JsonObj;
import com.github.cosycode.ext.se.json.JsonPrimary;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public interface JsonNode {
    public JsonNode getExpression(String var1);

    default public String getString(String expression) {
        JsonNode jsonNode = this.getExpression(expression);
        if (jsonNode == null) {
            return null;
        }
        return jsonNode.getAsString();
    }

    public String getAsString();

    default public boolean isJsonArr() {
        return this instanceof JsonArr;
    }

    default public boolean isJsonObj() {
        return this instanceof JsonObj;
    }

    default public boolean isJsonPrimary() {
        return this instanceof JsonPrimary;
    }

    default public boolean isJsonNul() {
        return this instanceof JsonNul;
    }

    default public JsonObj getAsJsonObj() {
        if (this.isJsonObj()) {
            return (JsonObj)this;
        }
        throw new IllegalStateException("Not a JSON Object: " + this);
    }

    default public JsonArr getAsJsonArr() {
        if (this.isJsonArr()) {
            return (JsonArr)this;
        }
        throw new IllegalStateException("Not a JSON Array: " + this);
    }

    default public JsonPrimary getAsJsonPrimary() {
        if (this.isJsonPrimary()) {
            return (JsonPrimary)this;
        }
        throw new IllegalStateException("Not a JSON Primary: " + this);
    }

    default public JsonNul getAsJsonNul() {
        if (this.isJsonNul()) {
            return (JsonNul)this;
        }
        throw new IllegalStateException("Not a JSON Null: " + this);
    }

    default public boolean getAsBoolean() {
        throw new IllegalStateException("Not a JSON Boolean: " + this);
    }

    default public Number getAsNumber() {
        throw new IllegalStateException("Not a JSON Number: " + this);
    }

    default public double getAsDouble() {
        throw new IllegalStateException("Not a JSON Double: " + this);
    }

    default public float getAsFloat() {
        throw new IllegalStateException("Not a JSON Float: " + this);
    }

    default public long getAsLong() {
        throw new IllegalStateException("Not a JSON Long: " + this);
    }

    default public int getAsInt() {
        throw new IllegalStateException("Not a JSON Integer: " + this);
    }

    default public byte getAsByte() {
        throw new IllegalStateException("Not a JSON Byte: " + this);
    }

    default public BigDecimal getAsBigDecimal() {
        throw new IllegalStateException("Not a JSON BigDecimal: " + this);
    }

    default public BigInteger getAsBigInteger() {
        throw new IllegalStateException("Not a JSON BigInteger: " + this);
    }

    default public short getAsShort() {
        throw new IllegalStateException("Not a JSON Short: " + this);
    }

    default public JsonArr getAsJsonArr(String expression) {
        JsonNode jsonNode = this.getExpression(expression);
        return jsonNode.getAsJsonArr();
    }

    default public JsonObj getAsJsonObj(String expression) {
        JsonNode jsonNode = this.getExpression(expression);
        return jsonNode.getAsJsonObj();
    }

    default public JsonPrimary getAsPrimary(String expression) {
        JsonNode jsonNode = this.getExpression(expression);
        return jsonNode.getAsJsonPrimary();
    }

    default public JsonNul getAsJsonNul(String expression) {
        JsonNode jsonNode = this.getExpression(expression);
        return jsonNode.getAsJsonNul();
    }

    public static List<DoubleBean<String, String>> splitExpression(String expression) {
        int len;
        if (!Pattern.matches("\\S+", expression)) {
            throw new IllegalArgumentException("the characters in expression can not be space char");
        }
        if (!expression.startsWith("[")) {
            expression = "." + expression.trim();
        }
        if ((len = expression.length()) <= 1) {
            throw new IllegalArgumentException("invalid expression: " + expression);
        }
        String tempExpression = expression.replaceAll("\\\\.", "\u0001\u0002");
        ArrayList<DoubleBean<String, String>> list = new ArrayList<DoubleBean<String, String>>();
        int idx = 0;
        while (idx < len) {
            char c = tempExpression.charAt(idx);
            if (c == '[') {
                int i;
                if (tempExpression.charAt(idx + 1) == ']') {
                    throw new BaseRuntimeException("\u5206\u6bb5\u4e3a\u7a7a [] " + expression, new Object[0]);
                }
                int leftCnt = 1;
                for (i = idx + 1; i < len; ++i) {
                    char ch = tempExpression.charAt(i);
                    if (ch == ']') {
                        if (--leftCnt > 0) continue;
                        list.add((DoubleBean<String, String>)DoubleBean.of((Object)Array.class.getSimpleName(), (Object)expression.substring(idx + 1, i)));
                        idx = i + 1;
                        break;
                    }
                    if (ch != '[') continue;
                    ++leftCnt;
                }
                if (i < len) continue;
                throw new BaseRuntimeException("\u89e3\u6790\u6570\u7ec4\u5931\u8d25: expression: %s, successPart: %s, fail: %s", new Object[]{expression, list, expression.substring(idx)});
            }
            if (c != '.') {
                throw new BaseRuntimeException("\u5206\u6bb5\u9996\u4f4d\u4e0d\u4e3a . \u4e5f\u4e0d\u4e3a [, \u89e3\u6790\u590d\u6742key\u5931\u8d25: expression: %s, successPart: %s, fail: %s", new Object[]{expression, list, expression.substring(idx)});
            }
            if (++idx >= len) {
                throw new BaseRuntimeException("\u672b\u5c3e\u4e3a\u70b9", new Object[0]);
            }
            c = tempExpression.charAt(idx);
            if (c == '\"') {
                if (tempExpression.charAt(idx + 1) == '\"') {
                    throw new BaseRuntimeException("\u5206\u6bb5\u4e3a\u7a7a \"\" " + expression, new Object[0]);
                }
                int tmp = tempExpression.indexOf(34, idx + 1);
                if (tmp < 0) {
                    throw new BaseRuntimeException("\u89e3\u6790\u590d\u6742key\u5931\u8d25: expression: %s, successPart: %s, fail: %s", new Object[]{expression, list, expression.substring(idx)});
                }
                list.add((DoubleBean<String, String>)DoubleBean.of((Object)Object.class.getSimpleName(), (Object)expression.substring(idx + 1, tmp)));
                idx = tmp + 1;
                continue;
            }
            if (c == '.' || c == '[') {
                throw new BaseRuntimeException("\u5206\u6bb5\u89e3\u6790\u5931\u8d25, \u53d1\u73b0\u4e24\u4e2a\u8fde\u7eed\u7684.. ., expression: %s, successPart: %s, fail: %s", new Object[]{expression, list, expression.substring(idx)});
            }
            int tmpP = tempExpression.indexOf(46, idx);
            int tmpL = tempExpression.indexOf("[", idx);
            if (tmpP < 0) {
                if (tmpL < 0) {
                    list.add((DoubleBean<String, String>)DoubleBean.of((Object)Object.class.getSimpleName(), (Object)expression.substring(idx)));
                    idx = expression.length();
                    continue;
                }
                list.add((DoubleBean<String, String>)DoubleBean.of((Object)Object.class.getSimpleName(), (Object)expression.substring(idx, tmpL)));
                idx = tmpL;
                continue;
            }
            if (tmpL < 0) {
                list.add((DoubleBean<String, String>)DoubleBean.of((Object)Object.class.getSimpleName(), (Object)expression.substring(idx, tmpP)));
                idx = tmpP;
                continue;
            }
            int min = Math.min(tmpL, tmpP);
            list.add((DoubleBean<String, String>)DoubleBean.of((Object)Object.class.getSimpleName(), (Object)expression.substring(idx, min)));
            idx = min;
        }
        if (idx != len) {
            throw new BaseRuntimeException("\u89e3\u6790\u8868\u8fbe\u5f0f\u5931\u8d25: expression: %s, successPart: %s", new Object[]{expression, list});
        }
        return list;
    }

    public static abstract class GsonNode
    implements JsonNode {
        public static GsonNode parse(String json) {
            JsonElement jsonElement = JsonParser.parseString((String)json);
            return GsonNode.geneGsonNode(jsonElement);
        }

        public static GsonNode geneGsonNode(JsonElement jsonElement) {
            if (jsonElement == null) {
                return null;
            }
            if (jsonElement.isJsonObject()) {
                return new JsonObj.GsonObj(jsonElement.getAsJsonObject());
            }
            if (jsonElement.isJsonArray()) {
                return new JsonArr.GsonArr(jsonElement.getAsJsonArray());
            }
            if (jsonElement.isJsonPrimitive()) {
                return new JsonPrimary.GsonPrimary(jsonElement.getAsJsonPrimitive());
            }
            if (jsonElement.isJsonNull()) {
                return new JsonNul.GsonNul();
            }
            throw new ShouldNotHappenException();
        }

        public abstract JsonElement getJsonElement();

        @Override
        public JsonNode getExpression(String expression) {
            JsonElement jsonElement0 = GsonNode.getJsonElement(this.getJsonElement(), expression);
            return GsonNode.geneGsonNode(jsonElement0);
        }

        @Override
        public String getAsString() {
            return this.getJsonElement().getAsString();
        }

        public String toString() {
            return this.getJsonElement().toString();
        }

        public static JsonElement getJsonElement(JsonElement jsonElement, @NonNull String expression) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            if (expression.contains("\\\\")) {
                throw new IllegalArgumentException("expression can't contain two slashes ==> " + expression);
            }
            List<DoubleBean<String, String>> doubleBeans = JsonNode.splitExpression(expression);
            for (DoubleBean<String, String> doubleBean : doubleBeans) {
                if (jsonElement == null) {
                    return null;
                }
                String type = (String)doubleBean.getO1();
                String numberString = (String)doubleBean.getO2();
                if (type.equals(Array.class.getSimpleName())) {
                    if (StringUtils.isNumeric((CharSequence)numberString)) {
                        int idx = Integer.parseInt(numberString);
                        jsonElement = jsonElement.getAsJsonArray().get(idx);
                        continue;
                    }
                    if (!numberString.contains("=")) continue;
                    String[] kvs = numberString.split(",");
                    JsonArray asJsonArray = jsonElement.getAsJsonArray();
                    List collect = asJsonArray.asList().stream().filter(it -> {
                        JsonObject asJsonObject = it.getAsJsonObject();
                        if (asJsonObject == null) {
                            return false;
                        }
                        for (String kv : kvs) {
                            String[] kAndV = kv.split("=");
                            JsonElement value = asJsonObject.get(kAndV[0]);
                            if (value == null) {
                                return false;
                            }
                            if (value.getAsString().equals(kAndV[1])) continue;
                            return false;
                        }
                        return true;
                    }).collect(Collectors.toList());
                    jsonElement = (JsonElement)CollectUtils.listToOneWithThrow(collect);
                    continue;
                }
                if (type.equals(Object.class.getSimpleName())) {
                    jsonElement = jsonElement.getAsJsonObject().get(numberString);
                    continue;
                }
                throw new NotSupportException();
            }
            return jsonElement;
        }
    }
}

