/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.se.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.cosycode.common.lang.BaseRuntimeException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import lombok.NonNull;

public class JsonUtils {
    private static JsonParser jsonParser = new GsonParser();

    private static JsonParser getJsonParser() {
        return jsonParser;
    }

    public static String toJson(Object obj) {
        return JsonUtils.getJsonParser().toJson(obj);
    }

    public static String toFormatJson(Object obj) {
        return JsonUtils.getJsonParser().toFormatJson(obj);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return JsonUtils.getJsonParser().fromJson(json, classOfT);
    }

    public static <T> List<T> fromJsonArray(String json, Class<T> classOfT) {
        return JsonUtils.getJsonParser().fromJsonArray(json, classOfT);
    }

    public static <T> String processJson(String json, Class<T> tClass, UnaryOperator<T> operator) {
        return JsonUtils.getJsonParser().processJson(json, tClass, operator);
    }

    public static <T> T fromJsonStrict(String json, Class<T> classOfT) {
        String sortJsonAfter;
        Objects.requireNonNull(json);
        Objects.requireNonNull(classOfT);
        T t = JsonUtils.fromJson(json, classOfT);
        String jsonAfter = JsonUtils.toJson(t);
        if (json.equals(jsonAfter)) {
            return t;
        }
        String sortJson = JsonUtils.toJson(JsonUtils.fromJson(json, TreeMap.class));
        if (sortJson.equals(sortJsonAfter = JsonUtils.toJson(JsonUtils.fromJson(json, TreeMap.class)))) {
            return t;
        }
        throw new BaseRuntimeException("json \u8f6c\u6362\u6210 classOf T, \u4fe1\u606f\u4e22\u5931, \n\u539f\u6765\u7684 json: %s, \u6392\u5e8f\u540e\u7684json: %s, \n\u8f6c\u6362\u6210 %s \u540e\u7684json: %s", new Object[]{json, sortJson, classOfT.getName(), sortJsonAfter});
    }

    public static <T> List<T> fromJsonArrayStrict(String json, Class<T> classOfT) {
        String sortJsonAfter;
        Objects.requireNonNull(json);
        Objects.requireNonNull(classOfT);
        List<T> tList = JsonUtils.fromJsonArray(json, classOfT);
        String jsonAfter = JsonUtils.toJson(tList);
        if (json.equals(jsonAfter)) {
            return tList;
        }
        String sortJson = JsonUtils.toJson(JsonUtils.fromJsonArray(json, TreeMap.class));
        if (sortJson.equals(sortJsonAfter = JsonUtils.toJson(JsonUtils.fromJsonArray(json, TreeMap.class)))) {
            return tList;
        }
        throw new BaseRuntimeException("json \u8f6c\u6362\u6210 classOf T, \u4fe1\u606f\u4e22\u5931, \n\u539f\u6765\u7684 json: %s, \u6392\u5e8f\u540e\u7684json: %s, \n\u8f6c\u6362\u6210 List<%s> \u540e\u7684json: %s", new Object[]{json, sortJson, classOfT.getName(), sortJsonAfter});
    }

    private JsonUtils() {
    }

    public static class JacksonParser
    implements JsonParser {
        public static final ObjectMapper MAPPER = new ObjectMapper();

        @Override
        public String toJson(Object obj) {
            if (obj == null) {
                return "{}";
            }
            try {
                return MAPPER.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                throw new BaseRuntimeException("[JacksonParser] writeValueAsString exception", (Throwable)e);
            }
        }

        @Override
        public String toFormatJson(Object obj) {
            if (obj == null) {
                return "{}";
            }
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
                return objectMapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                throw new BaseRuntimeException("[JacksonParser] writeValueAsString exception", (Throwable)e);
            }
        }

        @Override
        public <T> T fromJson(String json, Class<T> clazz) {
            if (json == null) {
                return null;
            }
            try {
                return (T)MAPPER.readValue(json, clazz);
            }
            catch (JsonProcessingException e) {
                throw new BaseRuntimeException("[JacksonParser] fromJson exception", (Throwable)e);
            }
        }

        @Override
        public <T> List<T> fromJsonArray(String json, Class<T> classOfT) {
            Class<?> arrClass = Array.newInstance(classOfT, 0).getClass();
            try {
                Object[] array = (Object[])MAPPER.readValue(json, arrClass);
                ArrayList ts = new ArrayList((int)((double)array.length * 1.4));
                Collections.addAll(ts, array);
                return ts;
            }
            catch (JsonProcessingException e) {
                throw new BaseRuntimeException("[JacksonParser] fromJsonArray", (Throwable)e);
            }
        }
    }

    public static class GsonParser
    implements JsonParser {
        @Override
        public String toJson(Object obj) {
            return new Gson().toJson(obj);
        }

        @Override
        public String toFormatJson(Object obj) {
            return new GsonBuilder().setPrettyPrinting().create().toJson(obj);
        }

        @Override
        public <T> T fromJson(String json, Class<T> classOfT) {
            return (T)new Gson().fromJson(json, classOfT);
        }

        @Override
        public <T> List<T> fromJsonArray(String json, Class<T> classOfT) {
            Class<T[]> arrClass = Array.newInstance(classOfT, 0).getClass();
            return this.nativeFromJsonArray(json, arrClass);
        }

        private <T> List<T> nativeFromJsonArray(String json, Class<T[]> classOfT) {
            Object[] ts = (Object[])new Gson().fromJson(json, classOfT);
            return Arrays.asList(ts);
        }
    }

    static interface JsonParser {
        public String toJson(Object var1);

        public String toFormatJson(Object var1);

        public <T> T fromJson(String var1, Class<T> var2);

        public <T> List<T> fromJsonArray(String var1, Class<T> var2);

        default public <T> String processJson(String json, Class<T> tClass, UnaryOperator<T> operator) {
            T before = this.fromJson(json, tClass);
            Object after = operator.apply(before);
            if (after == null) {
                return null;
            }
            return this.toJson(after);
        }
    }

    public static interface Config {
        public static void setJsonParser(@NonNull JsonParser jsonParser) {
            if (jsonParser == null) {
                throw new NullPointerException("jsonParser is marked non-null but is null");
            }
            jsonParser = jsonParser;
        }
    }
}

