/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.swing.comp;

import com.github.cosycode.ext.swing.inte.DropTargetListenerImpl;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.io.IOException;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPathTextField
extends JTextField {
    private static final Logger log = LoggerFactory.getLogger(JPathTextField.class);

    public JPathTextField() {
        this(null);
    }

    public JPathTextField(String text) {
        super(text);
        new DropTarget(this, 3, dropTargetDropEvent -> {
            try {
                String filePath = DropTargetListenerImpl.getFilePath(dropTargetDropEvent);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filePath})) {
                    this.setText(filePath);
                    return true;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                log.error("failed to drop file", (Throwable)e);
            }
            return false;
        });
    }
}

