/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.web.http;

import com.github.cosycode.common.ext.hub.LazySingleton;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class Http5ClientConfig {
    private static final int MAX_CONN_TOTAL = 200;
    private static final int CONNECT_TIME_OUT = 120;
    private static final LazySingleton<CloseableHttpClient> defaultCloseableHttpClient = LazySingleton.of(Http5ClientConfig::defaultHttpClient);

    public static CloseableHttpClient getCloseableHttpClient() {
        return (CloseableHttpClient)defaultCloseableHttpClient.instance();
    }

    public static CloseableHttpClient defaultHttpClient() {
        return Http5ClientConfig.defaultHttpClientBuilder().build();
    }

    public static HttpClientBuilder geneHttpClientBuilderWithBasicProxyAuthorization(String proxyServerDomain, int port, String username, String password) {
        AuthScope authScope = new AuthScope(proxyServerDomain, port);
        UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(username, password.toCharArray());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(authScope, (Credentials)proxyCredentials);
        HttpHost proxy = new HttpHost(proxyServerDomain, port);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        return Http5ClientConfig.defaultHttpClientBuilder().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setRoutePlanner((HttpRoutePlanner)routePlanner);
    }

    public static HttpClientBuilder geneHttpClientBuilderWithProxy(String proxyServerDomain, int port) {
        return Http5ClientConfig.defaultHttpClientBuilder().setProxy(new HttpHost(proxyServerDomain, port));
    }

    public static HttpClientBuilder defaultHttpClientBuilder() {
        return HttpClientBuilder.create().setConnectionManager(Http5ClientConfig.defaultHttpClientConnectionManager()).evictIdleConnections(TimeValue.ofMinutes((long)1L)).disableAutomaticRetries().setConnectionManagerShared(true).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy()).setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(180L, TimeUnit.SECONDS).setConnectionRequestTimeout(30L, TimeUnit.SECONDS).build());
    }

    public static HttpClientConnectionManager defaultHttpClientConnectionManager() {
        return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)Http5ClientConfig.getSSLFactory()).setMaxConnPerRoute(199).setMaxConnTotal(200).setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)120L)).setValidateAfterInactivity(TimeValue.ofSeconds((long)10L)).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(5, TimeUnit.SECONDS).build()).build();
    }

    public static SSLConnectionSocketFactory getSSLFactory() {
        X509ExtendedTrustManager trustManager = new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        assert (ctx != null);
        return new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }

    private Http5ClientConfig() {
    }
}

