/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.web.http;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.hc.core5.http.ContentType;

public class HttpHeaderHelper {
    public static void jsonHeader(@NonNull Map<String, Object> header) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        header.computeIfAbsent("Content-Type", k -> ContentType.APPLICATION_JSON);
        header.putIfAbsent("Accept-Encoding", "gzip, x-gzip, deflate");
        header.putIfAbsent("Connection", "keep-alive");
    }

    public static Map<String, Object> jsonHeader() {
        HashMap<String, Object> header = new HashMap<String, Object>();
        HttpHeaderHelper.jsonHeader(header);
        return header;
    }

    public static HttpHeaderBuilder build() {
        return new HttpHeaderBuilder();
    }

    public static class HttpHeaderBuilder {
        final Map<String, Object> headers = new HashMap<String, Object>();

        public Accept accept() {
            return new Accept();
        }

        public ContentType contentType() {
            return new ContentType();
        }

        public CacheControl cacheControl() {
            return new CacheControl();
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public class CacheControl {
            public HttpHeaderBuilder no$cache() {
                HttpHeaderBuilder.this.headers.put("cache-control", "no-cache");
                return HttpHeaderBuilder.this;
            }
        }

        public class ContentType {
            public HttpHeaderBuilder application$Json() {
                HttpHeaderBuilder.this.headers.put("content-type", "application/json");
                return HttpHeaderBuilder.this;
            }
        }

        public class Accept {
            public HttpHeaderBuilder application$Json() {
                HttpHeaderBuilder.this.headers.put("accept", "application/json");
                return HttpHeaderBuilder.this;
            }
        }
    }
}

