/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.web.http;

import com.github.cosycode.ext.web.http.MyHttpClient;
import com.github.cosycode.ext.web.http.MyHttpRequest;
import com.github.cosycode.ext.web.http.MyHttpResponse;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.hc.core5.http.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);

    private HttpHelper() {
    }

    public static MyHttpRequestHelper buildGet(String url) {
        return new MyHttpRequestHelper(Method.GET.name(), url);
    }

    public static MyHttpRequestHelper buildPut(String url) {
        return new MyHttpRequestHelper(Method.PUT.name(), url);
    }

    public static MyHttpRequestHelper buildPost(String url) {
        return new MyHttpRequestHelper(Method.POST.name(), url);
    }

    public static MyHttpRequestHelper buildDelete(String url) {
        return new MyHttpRequestHelper(Method.DELETE.name(), url);
    }

    public static MyHttpRequestHelper buildPatch(String url) {
        return new MyHttpRequestHelper(Method.PATCH.name(), url);
    }

    public static class MyHttpRequestHelper
    extends MyHttpRequest {
        @Override
        public MyHttpRequestHelper method(String method) {
            super.method(method);
            return this;
        }

        @Override
        public MyHttpRequestHelper headers(Map<String, Object> headers) {
            super.headers(headers);
            return this;
        }

        @Override
        public MyHttpRequestHelper requestUrl(String requestUrl) {
            super.requestUrl(requestUrl);
            return this;
        }

        @Override
        public MyHttpRequestHelper params(Map<String, String> params) {
            super.params(params);
            return this;
        }

        @Override
        public MyHttpRequestHelper jsonBody(Object jsonBody) {
            super.jsonBody(jsonBody);
            return this;
        }

        public MyHttpRequestHelper(String method, String requestUrl) {
            super(method, requestUrl);
        }

        public MyHttpResponse send() throws IOException {
            return this.send(null);
        }

        public MyHttpResponse send(Consumer<MyHttpRequest> consumer) throws IOException {
            MyHttpClient instance = (MyHttpClient)MyHttpClient.DEFAULT_INSTANCE.instance();
            return MyHttpClient.send(this, instance.closeableHttpClient, instance.webCacheHandler, MyHttpResponse.DEFAULT_HANDLER, consumer, instance.postProcess);
        }

        public MyHttpResponse sendBy(@NonNull MyHttpClient client) throws IOException {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            return client.send(this);
        }

        public MyHttpResponse sendBy() throws IOException {
            return ((MyHttpClient)MyHttpClient.DEFAULT_INSTANCE.instance()).send(this);
        }

        public MyHttpResponse downloadBy(@NonNull MyHttpClient client, String savePath) throws IOException {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            return client.download(this, savePath);
        }

        public MyHttpResponse downloadBy(String savePath) throws IOException {
            return ((MyHttpClient)MyHttpClient.DEFAULT_INSTANCE.instance()).download(this, savePath);
        }
    }
}

