/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.web.http;

import com.github.cosycode.common.util.io.FileSystemUtils;
import com.github.cosycode.ext.se.util.JsonUtils;
import com.github.cosycode.ext.web.http.MyHttpResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class MyHttpDownloadResponseHandler
implements HttpClientResponseHandler<MyHttpResponse> {
    private final String savePath;

    public MyHttpDownloadResponseHandler(String savePath) {
        this.savePath = savePath;
    }

    public MyHttpResponse handleResponse(ClassicHttpResponse response) throws IOException {
        int responseCode = response.getCode();
        HttpEntity entity = response.getEntity();
        DownloadResponse downloadResponse = new DownloadResponse();
        downloadResponse.setFilePath(this.savePath);
        downloadResponse.setFileLength(entity.getContentLength());
        downloadResponse.setStartTime(System.nanoTime());
        downloadResponse.setMessage("start downloading");
        File file = new File(this.savePath);
        FileSystemUtils.insureFileDirExist((File)file.getParentFile());
        try (InputStream inputStream = entity.getContent();
             OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[65536];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                downloadResponse.addWriteLength(bytesRead);
            }
        }
        downloadResponse.setMessage("download success");
        downloadResponse.setEndTime(System.nanoTime());
        return new MyHttpResponse(responseCode, JsonUtils.toJson(downloadResponse));
    }

    public static class DownloadResponse {
        String contentType;
        long startTime;
        long endTime;
        String message;
        String filePath;
        long fileLength;
        long writeLength;

        private void addWriteLength(int length) {
            this.writeLength += (long)length;
        }

        public String getContentType() {
            return this.contentType;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public String getMessage() {
            return this.message;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public long getWriteLength() {
            return this.writeLength;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public void setFileLength(long fileLength) {
            this.fileLength = fileLength;
        }

        public void setWriteLength(long writeLength) {
            this.writeLength = writeLength;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DownloadResponse)) {
                return false;
            }
            DownloadResponse other = (DownloadResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            if (this.getEndTime() != other.getEndTime()) {
                return false;
            }
            if (this.getFileLength() != other.getFileLength()) {
                return false;
            }
            if (this.getWriteLength() != other.getWriteLength()) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            return !(this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DownloadResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            long $endTime = this.getEndTime();
            result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
            long $fileLength = this.getFileLength();
            result = result * 59 + (int)($fileLength >>> 32 ^ $fileLength);
            long $writeLength = this.getWriteLength();
            result = result * 59 + (int)($writeLength >>> 32 ^ $writeLength);
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            return result;
        }

        public String toString() {
            return "MyHttpDownloadResponseHandler.DownloadResponse(contentType=" + this.getContentType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", message=" + this.getMessage() + ", filePath=" + this.getFilePath() + ", fileLength=" + this.getFileLength() + ", writeLength=" + this.getWriteLength() + ")";
        }
    }
}

