/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.web.http;

import com.github.cosycode.common.lang.BaseRuntimeException;
import com.github.cosycode.ext.se.util.JsonUtils;
import com.github.cosycode.ext.web.http.MyHttpResponse;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class MyHttpEntityResponse<T>
extends MyHttpResponse {
    private final String convertType;
    private final Object convertObject;

    public static <R> MyHttpEntityResponse<R> newWithJsonParser(int code, String data, Class<?> clazz) {
        return new MyHttpEntityResponse(code, data, "json", clazz);
    }

    public static <R> MyHttpEntityResponse<R> newWithCustomParser(int code, String data, Function<MyHttpResponse, R> function) {
        return new MyHttpEntityResponse(code, data, "custom", function);
    }

    private MyHttpEntityResponse(int code, String data, String convertType, Object convertObject) {
        super(code, data);
        this.convertType = convertType;
        this.convertObject = convertObject;
    }

    public T toEntity() {
        if (this.isCode(404)) {
            return null;
        }
        if (!this.isSuccess() || StringUtils.isBlank((CharSequence)this.data())) {
            throw new BaseRuntimeException("can't convert to Entity, code or data is abnormal ==> %s", new Object[]{JsonUtils.toJson(this)});
        }
        switch (this.convertType) {
            case "json": {
                Class tClass = (Class)this.convertObject;
                return JsonUtils.fromJson(this.data(), tClass);
            }
            case "custom": {
                Function convertFunction = (Function)this.convertObject;
                return (T)convertFunction.apply(this);
            }
        }
        throw new BaseRuntimeException("can't convert, not support the type: %s, ==> %s", new Object[]{this.convertType, this});
    }

    static <T> HttpClientResponseHandler<MyHttpEntityResponse<T>> getReasonPhrase(Class<T> tClass) {
        return response -> {
            int responseCode = response.getCode();
            HttpEntity entity = response.getEntity();
            if (responseCode < 500 && responseCode >= 200) {
                String responseData;
                if (entity == null) {
                    responseData = null;
                } else {
                    try {
                        responseData = EntityUtils.toString((HttpEntity)entity);
                    }
                    catch (ParseException var3) {
                        throw new ClientProtocolException((Throwable)var3);
                    }
                }
                return MyHttpEntityResponse.newWithJsonParser(responseCode, responseData, tClass);
            }
            try {
                String responseData = EntityUtils.toString((HttpEntity)entity);
                return MyHttpEntityResponse.newWithJsonParser(responseCode, responseData, tClass);
            }
            catch (ParseException var3) {
                EntityUtils.consume((HttpEntity)entity);
                throw new HttpResponseException(responseCode, response.getReasonPhrase());
            }
        };
    }
}

