/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.web.http;

import com.github.cosycode.ext.web.http.MyHttpClient;
import com.github.cosycode.ext.web.http.MyHttpRequest;
import com.github.cosycode.ext.web.http.MyHttpResponse;
import java.io.IOException;
import java.util.function.BiFunction;
import lombok.NonNull;

public class MyHttpTransaction {
    private final transient MyHttpClient client;
    private final MyHttpRequest request;
    protected MyHttpResponse response;

    public static MyHttpTransaction generate(MyHttpClient client, MyHttpRequest request) {
        return new MyHttpTransaction(client, request);
    }

    public MyHttpTransaction(MyHttpClient client, MyHttpRequest request) {
        this.client = client;
        this.request = request;
    }

    public MyHttpResponse send() throws IOException {
        return this.client.send(this.request);
    }

    public <R> R send(@NonNull MyHttpTransactionFunction<R> responseDisposer) throws IOException {
        if (responseDisposer == null) {
            throw new NullPointerException("responseDisposer is marked non-null but is null");
        }
        return (R)((Handler)new Handler<R>(this.client, this.request, responseDisposer)).sendRequest();
    }

    public <R> R sendAndCatchException(@NonNull MyHttpTransactionFunction<R> responseDisposer, BiFunction<Handler<R>, Exception, R> catchDisposer) {
        if (responseDisposer == null) {
            throw new NullPointerException("responseDisposer is marked non-null but is null");
        }
        Handler<R> httpTransaction = new Handler<R>(this.client, this.request, responseDisposer);
        try {
            return (R)((Handler)httpTransaction).sendRequest();
        }
        catch (IOException e) {
            if (catchDisposer == null) {
                throw new RuntimeException(e);
            }
            return catchDisposer.apply(httpTransaction, e);
        }
    }

    public <R> R sendWithRuntimeException(@NonNull MyHttpTransactionFunction<R> responseDisposer) {
        if (responseDisposer == null) {
            throw new NullPointerException("responseDisposer is marked non-null but is null");
        }
        return this.sendAndCatchException(responseDisposer, null);
    }

    public String toString() {
        return "MyHttpTransaction{request=" + this.request + ", response=" + this.response + '}';
    }

    public MyHttpClient client() {
        return this.client;
    }

    public MyHttpRequest request() {
        return this.request;
    }

    public MyHttpResponse response() {
        return this.response;
    }

    public class Handler<R>
    extends MyHttpTransaction {
        private final transient MyHttpTransactionFunction<R> responseDisposer;
        private int retryTime;

        public Handler(MyHttpClient client, @NonNull MyHttpRequest request, MyHttpTransactionFunction<R> responseDisposer) {
            super(client, request);
            if (responseDisposer == null) {
                throw new NullPointerException("responseDisposer is marked non-null but is null");
            }
            this.responseDisposer = responseDisposer;
        }

        public MyHttpResponse retry(int cnt) throws IOException {
            if (cnt > this.retryTime) {
                this.sendRequest();
            }
            throw new IOException(String.format("try %s times, and all fails ==> %s", this.retryTime, this));
        }

        private R sendRequest() throws IOException {
            ++this.retryTime;
            this.response = MyHttpTransaction.this.client.send(MyHttpTransaction.this.request);
            return this.responseDisposer.apply(this, this.response);
        }

        @Override
        public String toString() {
            return "MyHttpTransaction{request=" + MyHttpTransaction.this.request + ", response=" + this.response + ", retryTime=" + this.retryTime + '}';
        }
    }

    @FunctionalInterface
    public static interface MyHttpTransactionFunction<R> {
        public R apply(Handler<R> var1, MyHttpResponse var2) throws IOException;
    }
}

