/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.dataformat;

import com.github.cosycode.ext.dataformat.TypeConverter;
import java.lang.reflect.Field;

public class BeanUtils {
    private BeanUtils() {
    }

    public static String[] getFieldString(Class<?> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        String[] filedString = new String[declaredFields.length];
        int len = declaredFields.length;
        for (int i = 0; i < len; ++i) {
            filedString[i] = declaredFields[i].getName();
        }
        return filedString;
    }

    public static <T> Object[] getValueObj(Class<? super T> clazz, T t) {
        Field[] declaredFields = clazz.getDeclaredFields();
        Object[] fieldObj = new Object[declaredFields.length];
        for (Field field : declaredFields) {
            field.setAccessible(true);
            try {
                fieldObj[i] = field.get(t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return fieldObj;
    }

    public static <T> String[] getStringValueObj(Class<? super T> clazz, T t) {
        Field[] declaredFields = clazz.getDeclaredFields();
        String[] stringArr = new String[declaredFields.length];
        for (Field field : declaredFields) {
            field.setAccessible(true);
            try {
                Object obj = field.get(t);
                if (obj == null) {
                    stringArr[i] = "";
                    continue;
                }
                stringArr[i] = TypeConverter.convertObjToString(obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return stringArr;
    }
}

